/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.KeyboardUtil;
import com.install4j.runtime.wizard.CustomFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class LanguageSelectionDialog
extends CustomFrame
implements ActionListener {
    private static final int FRAME_WIDTH = 350;
    private JComboBox cmbLanguage;
    private JButton btnOk;
    private JButton btnCancel;
    private boolean canceled;
    private ReturnToken returnToken;
    private ResourceBundle messages;

    public LanguageSelectionDialog(ReturnToken returnToken) {
        this.returnToken = returnToken;
        GUIHelper.setLaF();
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        String systemLanguageId = InstallerUtil.getSupportedSystemLanguageId();
        this.messages = config.isLanguageSelectionInPrincipalLanguage() || systemLanguageId == null ? Messages.createMessages(config.getLanguages().get(0)) : Messages.createMessages(config.getLanguageById(systemLanguageId));
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.btnOk) {
            this.doOk();
        } else if (source == this.btnCancel) {
            this.doCancel();
        }
    }

    private void setupControls() {
        List<LanguageConfig> languages = InstallerConfig.getCurrentInstance().getLanguages();
        Locale systemLocale = Locale.getDefault();
        LanguageConfig systemLanguage = InstallerConfig.getCurrentInstance().getLanguageById(systemLocale.toString());
        if (systemLanguage == null) {
            systemLanguage = InstallerConfig.getCurrentInstance().getLanguageById(systemLocale.getLanguage());
        }
        if (systemLanguage == null) {
            systemLanguage = languages.get(0);
        }
        List<LanguageConfig> sortedLanguages = Messages.sortLanguages(languages, this.messages);
        this.cmbLanguage = new JComboBox<Object>(sortedLanguages.toArray());
        this.cmbLanguage.setSelectedItem(systemLanguage);
        this.cmbLanguage.setRenderer(new LanguageRenderer());
        this.btnOk = new JButton(this.messages.getString("ButtonOK"));
        this.btnCancel = new JButton(this.messages.getString("ButtonCancel"));
    }

    private String getLocalizedLanguageName(LanguageConfig value) {
        return Messages.getLocalizedLanguageName(value, this.messages);
    }

    private void setupComponent() {
        GUIHelper.setIconImages(this);
        this.setTitle(this.messages.getString("LanguageSelectionDialogTitle"));
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(7, 7, 7, 7);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 10;
        gc.gridheight = 2;
        Application currentApplication = InstallerConfig.getCurrentApplication();
        ImageIcon icon32 = currentApplication.isUseCustomIcon() ? this.get32By32Image(currentApplication.getCustomIconImageFiles()) : GUIHelper.DEFAULT_ICON_FRAME_32;
        contentPane.add((Component)new JLabel(icon32), gc);
        gc.gridx = 1;
        gc.gridheight = 1;
        gc.anchor = 17;
        contentPane.add((Component)new JLabel(this.messages.getString("LanguageSelectionLabel")), gc);
        gc.gridy = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        contentPane.add((Component)this.cmbLanguage, gc);
        Box box = ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnOk, this.btnCancel}, 1);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        contentPane.add((Component)box, gc);
        this.setContentPane(contentPane);
        this.setBackground(contentPane.getBackground());
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setBounds(this.getNewFrameBounds());
        this.setResizable(false);
    }

    private ImageIcon get32By32Image(List<? extends File> imageFiles) {
        for (File file : imageFiles) {
            ImageIcon icon = GUIHelper.loadIcon(file);
            if (icon.getIconWidth() != 32) continue;
            return icon;
        }
        return GUIHelper.DEFAULT_ICON_FRAME_32;
    }

    private void setupEventHandlers() {
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                LanguageSelectionDialog.this.doCancel();
            }
        });
        KeyboardUtil.addAccelerator(1, this.btnCancel, (JComponent)this.getContentPane(), this, 27, 0);
    }

    @Override
    protected int getFrameWidth() {
        return 350;
    }

    @Override
    protected int getFrameHeight() {
        return -1;
    }

    private void doCancel() {
        this.canceled = true;
        this.setVisible(false);
    }

    private void doOk() {
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible) {
        boolean wasVisible = this.isVisible();
        super.setVisible(visible);
        if (!visible) {
            this.returnToken.returnToController(this.getSelectedLanguageId());
            if (wasVisible) {
                this.dispose();
            }
        }
    }

    private String getSelectedLanguageId() {
        if (this.canceled) {
            return null;
        }
        return ((LanguageConfig)this.cmbLanguage.getSelectedItem()).getId();
    }

    private class LanguageRenderer
    extends DefaultListCellRenderer {
        private LanguageRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof LanguageConfig) {
                value = LanguageSelectionDialog.this.getLocalizedLanguageName((LanguageConfig)value);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

