/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.context.Context;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.comm.impl.HelperContextImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClasspathModificator {
    private static ClassLoader classLoader;
    private static Method addURLMethod;
    private static boolean customJarsAdded;
    private static Set<File> addedFiles;

    public static void addClassPath(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                ClasspathModificator.addClassPathInt(file);
            }
        });
    }

    private static void addClassPathInt(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (addedFiles.contains(file)) {
            return;
        }
        if (addURLMethod == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            addURLMethod = ClasspathModificator.getAddURLMethod();
        }
        try {
            addURLMethod.invoke((Object)classLoader, file.toURI().toURL());
            String previousClassPath = System.getProperty("java.class.path");
            System.setProperty("java.class.path", previousClassPath + (previousClassPath.endsWith(File.pathSeparator) ? "" : File.pathSeparator) + file.getAbsolutePath());
            addedFiles.add(file);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getAddURLMethod() {
        try {
            Method m = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addCustomJarsToClasspath(Context context) {
        if (customJarsAdded) {
            return;
        }
        if (InstallerUtil.isInProcess()) {
            ClasspathModificator.addClassPath(new File(ResourceHelper.getRuntimeDir(), "user.jar"));
            File[] userFiles = new File(ResourceHelper.getRuntimeDir(), "user").listFiles();
            if (userFiles != null) {
                for (File userFile : userFiles) {
                    if (!userFile.getName().endsWith(".jar") && !userFile.getName().endsWith(".zip")) continue;
                    ClasspathModificator.addClassPath(userFile);
                }
            }
        }
        List<String> customJars = InstallerConfig.getCurrentInstance().getCustomJars();
        for (String customJar : customJars) {
            File destinationFile = context.getDestinationFile(customJar);
            if (destinationFile == null) continue;
            ClasspathModificator.addClassPath(destinationFile);
        }
        customJarsAdded = true;
    }

    public static void addCustomJarsToHelperClasspath(HelperContextImpl helperContext) {
        if (customJarsAdded) {
            return;
        }
        if (InstallerUtil.isInProcess()) {
            ClasspathModificator.addClassPath(new File(ResourceHelper.getRuntimeDir(), "user.jar"));
        }
        List<String> customJars = InstallerConfig.getCurrentInstance().getCustomJars();
        for (String customJar : customJars) {
            File destinationFile = helperContext.getDestinationFile(customJar);
            if (destinationFile == null) continue;
            ClasspathModificator.addClassPathInt(destinationFile);
        }
        customJarsAdded = true;
    }

    static {
        customJarsAdded = false;
        addedFiles = new HashSet<File>();
        String classPath = System.getProperty("java.class.path");
        if (classPath != null) {
            String[] paths;
            for (String path : paths = classPath.split(File.pathSeparator)) {
                if (path.length() <= 0) continue;
                try {
                    addedFiles.add(new File(path).getCanonicalFile());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }
}

