/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class ServiceHandler {
    private static boolean servicesStopped = false;

    public static void resetStopState() {
        servicesStopped = false;
    }

    public static void stopServices(Context context, boolean force) {
        if (!force && servicesStopped) {
            return;
        }
        if (!InstallerUtil.isWindows()) {
            return;
        }
        List<String> services = ContextImpl.getContextInt(context).getInstallationProperties().getPropertyList("service");
        List<String> serviceNames = ContextImpl.getContextInt(context).getInstallationProperties().getPropertyList("serviceName");
        if (services.size() > 0 || serviceNames.size() > 0) {
            ProgressInterface progressInterface = context.getProgressInterface();
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusStoppingServices"));
            progressInterface.setDetailMessage(" ");
            progressInterface.setIndeterminateProgress(true);
            context.runElevated(new StopRemoteCallable(services, serviceNames), true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            progressInterface.setIndeterminateProgress(false);
        }
        servicesStopped = true;
    }

    private static class StopRemoteCallable
    extends AbstractRemoteCallable {
        List<String> services;
        List<String> serviceNames;

        private StopRemoteCallable(List<String> services, List<String> serviceNames) {
            this.services = services;
            this.serviceNames = serviceNames;
        }

        @Override
        public Serializable execute() {
            for (String service : this.services) {
                Logger.getInstance().info(ServiceHandler.class, "Stopping service " + service);
                if (!new File(service).exists()) continue;
                try {
                    Process process = new ProcessBuilder(service, "/stop").start();
                    process.waitFor();
                }
                catch (IOException e) {
                    Logger.getInstance().log(e);
                }
                catch (InterruptedException e) {
                    Logger.getInstance().log(e);
                }
            }
            for (String serviceName : this.serviceNames) {
                Logger.getInstance().info(ServiceHandler.class, "Stopping service " + serviceName);
                try {
                    Win32Services.stopService(serviceName);
                }
                catch (Win32Services.ServiceException e) {
                    if (e.getErrorCode() == 1062 || e.getErrorCode() == 1060) continue;
                    Logger.getInstance().log(e);
                }
            }
            return null;
        }
    }
}

