/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.installer.helper.content.ProxyHelper;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class HttpRequestHandler {
    public static final int MODE_GUI = 1;
    public static final int MODE_CONSOLE = 2;
    public static final int MODE_UNATTENDED = 3;
    public static final String SYSPROP_SHOW_CONNECT_ERROR = "install4j.showConnectError";
    private static final String SYSPROP_SHOW_PROXY_CONFIG = "install4j.showProxyConfig";
    private static final String SYSPROP_NO_PROXY_AUTO_DETECT = "install4j.noProxyAutoDetect";
    private static final String SYSPROP_NO_PROXY = "install4j.noProxy";
    private static final String SYSPROP_CONNECT_TIMEOUT = "install4j.connectTimeout";
    private static final String SYSPROP_INSTALL4J_READ_TIMEOUT = "install4j.readTimeout";
    private static ProxyConfig proxyConfig = new ProxyConfig();
    private Context context;
    private boolean askForProxy = false;
    private boolean showProxyOnErrorCode = false;
    private boolean acceptAllCertificates = false;
    private URLConnection connection;
    private int mode;
    private ProxyHostInfo proxyHostInfo;
    private Map<String, List<String>> requestHeaders = new LinkedHashMap<String, List<String>>();
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private boolean readResponse = true;
    private volatile boolean canceled;

    public static ProxyConfig getProxyConfig() {
        return proxyConfig;
    }

    protected HttpRequestHandler(Context context) {
        this(context, context.isUnattended() ? 3 : (context.isConsole() ? 2 : 1));
    }

    protected HttpRequestHandler(Context context, int mode) {
        this.context = context;
        this.mode = mode;
    }

    public void cancel() {
        this.canceled = true;
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    public void setAskForProxy(boolean askForProxy) {
        this.askForProxy = askForProxy;
    }

    public void setShowProxyOnErrorCode(boolean showProxyOnErrorCode) {
        this.showProxyOnErrorCode = showProxyOnErrorCode;
    }

    public void setRequestHeaders(Map<String, List<String>> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setAcceptAllCertificates(boolean acceptAllCertificates) {
        this.acceptAllCertificates = acceptAllCertificates;
    }

    public void setReadResponse(boolean readResponse) {
        this.readResponse = readResponse;
    }

    protected boolean isReadResponse() {
        return this.readResponse;
    }

    protected Context getContext() {
        return this.context;
    }

    public HttpRequestHandler connect(String urlString) throws IOException, UserCanceledException {
        return this.connect(urlString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequestHandler connect(String urlString, ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        URL url = new URL(urlString);
        Runnable resetter = this.maybeAcceptAllCertificates(url);
        try {
            this.connection = this.getURLConnection(url, connectionPreparer, this.showProxyOnErrorCode);
        }
        finally {
            if (resetter != null) {
                resetter.run();
            }
        }
        this.connectionInitialized(this.connection);
        if (this.isReadResponse()) {
            try {
                this.connection.getInputStream();
            }
            catch (IOException e) {
                String message;
                String string = message = this.proxyHostInfo == null ? "No auto-detected proxy was used" : "Auto-detected proxy was " + this.proxyHostInfo;
                if (this.context != null) {
                    ContextInt contextInt = ContextImpl.getContextInt(this.context);
                    if (contextInt != null) {
                        Logger.getInstance().info(contextInt.getEventSource(), message);
                    }
                } else if (Boolean.getBoolean(SYSPROP_SHOW_CONNECT_ERROR)) {
                    System.err.println(message);
                    System.err.println("proxySet = " + System.getProperty("proxySet"));
                    System.err.println("proxyHost = " + System.getProperty("proxyHost"));
                    System.err.println("proxyPort = " + System.getProperty("proxyPort"));
                }
                throw e;
            }
        }
        return this;
    }

    private Runnable maybeAcceptAllCertificates(URL url) {
        if (!this.acceptAllCertificates || !url.getProtocol().equals("https")) {
            return null;
        }
        final SSLSocketFactory defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        final HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            // empty catch block
        }
        return new Runnable(){

            @Override
            public void run() {
                HttpsURLConnection.setDefaultSSLSocketFactory(defaultSSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(defaultHostnameVerifier);
            }
        };
    }

    protected void connectionInitialized(URLConnection connection) {
    }

    public void disconnect() throws IOException {
        this.connection.getInputStream().close();
    }

    protected boolean isCancelled() {
        return this.context != null && this.context.isCancelling() || this.canceled;
    }

    /*
     * Unable to fully structure code
     */
    private URLConnection getURLConnection(URL url, ConnectionPreparer connectionPreparer, boolean showProxyOnErrorCode) throws IOException, UserCanceledException {
        if (!Boolean.getBoolean("install4j.noProxy")) {
            if (!Boolean.getBoolean("install4j.noProxyAutoDetect") && !Boolean.getBoolean("install4j.showProxyConfig")) {
                this.proxyHostInfo = ProxyHelper.getProxyHostInfo(url);
                HttpRequestHandler.proxyConfig.update(this.proxyHostInfo);
            } else {
                this.proxyHostInfo = null;
                HttpRequestHandler.proxyConfig.setProperties();
            }
        }
        HttpAuthenticator.setRequestHandler(this);
        while (true) lbl-1000:
        // 3 sources

        {
            if (this.context != null && this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            try {
                if (Boolean.getBoolean("install4j.showProxyConfig") || !InstallerUtil.isAtLeastJava15() && HttpRequestHandler.proxyConfig.isProxySet() && HttpRequestHandler.proxyConfig.isPasswordRequired()) {
                    System.setProperty("install4j.showProxyConfig", "false");
                    System.setProperty("install4j.noProxyAutoDetect", "true");
                    this.askForProxyPassword();
                }
                connection = url.openConnection();
                connection.addRequestProperty("X-Client-Application", "install4j");
                connection.setConnectTimeout(Integer.getInteger("install4j.connectTimeout", this.connectTimeout));
                connection.setReadTimeout(Integer.getInteger("install4j.readTimeout", this.readTimeout));
                HttpRequestHandler.proxyConfig.updateConnection(connection);
                for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
                    key = entry.getKey();
                    values = entry.getValue();
                    if (key.isEmpty()) continue;
                    for (String value : values) {
                        if (value.isEmpty()) continue;
                        connection.addRequestProperty(key, value);
                    }
                }
                cookies = System.getProperty("install4j.cookies");
                if (cookies != null && !this.requestHeaders.containsKey("Cookie")) {
                    connection.setRequestProperty("Cookie", cookies);
                }
                if (connectionPreparer != null) {
                    connectionPreparer.prepare(connection);
                }
                connection.connect();
                if (showProxyOnErrorCode && this.askForProxy && this.mode != 3 && connection instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)connection).getResponseCode() / 200 != 1) {
                    throw new IOException();
                }
                if (Boolean.getBoolean("install4j.showConnectError") && connection instanceof HttpURLConnection) {
                    httpURLConnection = (HttpURLConnection)connection;
                    System.err.println("response code = " + httpURLConnection.getResponseCode());
                    System.err.println("response message = " + httpURLConnection.getResponseMessage());
                    System.err.println("header fields = " + httpURLConnection.getHeaderFields());
                }
                return connection;
            }
            catch (SSLHandshakeException e) {
                throw e;
            }
            catch (IOException e) {
                if (this.handleProxyFailure(url)) ** GOTO lbl-1000
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (this.handleProxyFailure(url)) continue;
                throw e;
            }
            break;
        }
    }

    private boolean handleProxyFailure(URL url) throws IOException, UserCanceledException {
        String host = url.getHost();
        if (host.equals("localhost") || host.equals("127.0.0.1")) {
            return false;
        }
        if (!proxyConfig.isProxySet() && proxyConfig.getHost().length() > 0) {
            proxyConfig.setProxySet(true);
            proxyConfig.setProperties();
            return true;
        }
        if (this.mode == 3 || !this.askForProxy) {
            return false;
        }
        proxyConfig.show(this.mode == 2, false);
        if (proxyConfig.isCanceled()) {
            throw new UserCanceledException();
        }
        return true;
    }

    public void askForProxyPassword() throws IOException, UserCanceledException {
        if (this.mode == 3 && System.getProperty("proxyAuthPassword") != null) {
            return;
        }
        if (this.mode == 3 || !this.askForProxy) {
            throw new IOException(Messages.getMessages().getString("ProxyPasswordRequired"));
        }
        proxyConfig.show(this.mode == 2, true);
        if (proxyConfig.isCanceled()) {
            throw new UserCanceledException();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public static interface ConnectionPreparer {
        public void prepare(URLConnection var1) throws IOException;
    }
}

