/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.helper.content.CountingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class SplittedFileInputStream
extends InputStream {
    private CountingInputStream in;
    private long currentFileSize;
    private File mainFile;
    private int nextIndex = 0;

    protected SplittedFileInputStream(File mainFile) throws FileNotFoundException {
        this.in = new CountingInputStream(new FileInputStream(mainFile));
        this.currentFileSize = mainFile.length();
        this.mainFile = mainFile;
    }

    private boolean checkNextFile() throws IOException {
        File newFile = new File(this.mainFile.getAbsolutePath() + "." + this.nextIndex++);
        if (newFile.exists()) {
            this.in.close();
            this.in = new CountingInputStream(new FileInputStream(newFile));
            this.currentFileSize = newFile.length();
            return true;
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        int res = this.in.read();
        if (res == -1 && this.checkNextFile()) {
            return this.read();
        }
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isCurrentEOF() && this.checkNextFile()) {
            return this.read(b, off, len);
        }
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.isCurrentEOF() && this.checkNextFile()) {
            return this.skip(n);
        }
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.isCurrentEOF() && this.checkNextFile()) {
            return this.available();
        }
        return this.in.available();
    }

    private boolean isCurrentEOF() {
        return this.in.getCount() >= this.currentFileSize;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

