/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Common {
    private static final String LIBRARY_NAME = "i4jinst";
    public static final String LIBRARY_FILENAME = "i4jinst.dll";
    public static final String EXT_32_BIT = ".32";
    public static final String EXT_64_BIT = ".64";
    private static boolean initialized = false;

    private static native void setWindows95(boolean var0);

    private static native void setWindowsNT(boolean var0);

    public static void init() {
        if (InstallerUtil.isWindows() && !initialized) {
            initialized = true;
            File zipFile = new File(System.getProperty("user.dir"), "platform.zip");
            try {
                ZipInputStream zin = new ZipInputStream(new FileInputStream(zipFile));
                ZipEntry zipEntry = zin.getNextEntry();
                while (zipEntry != null) {
                    FileOutputStream out = new FileOutputStream(new File(System.getProperty("user.dir"), zipEntry.getName()));
                    FileUtil.pumpStream(zin, out);
                    ((OutputStream)out).close();
                    zipEntry = zin.getNextEntry();
                }
                zin.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            boolean is64Bit = System.getProperty("os.arch").contains("64");
            File debug64BitLibrary = InstallerUtil.getInstallerFile("i4jinst.dll.64");
            File debug32BitLibrary = InstallerUtil.getInstallerFile("i4jinst.dll.32");
            if (is64Bit && debug64BitLibrary.exists()) {
                System.load(debug64BitLibrary.getAbsolutePath());
            } else if (!is64Bit && debug32BitLibrary.exists()) {
                System.load(debug32BitLibrary.getAbsolutePath());
            } else {
                File defaultFile = new File(ResourceHelper.getRuntimeDir(), LIBRARY_FILENAME);
                try {
                    System.load(defaultFile.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError e) {
                    String shortPathName = new File(System.getProperty("user.dir"), LIBRARY_FILENAME).getAbsolutePath();
                    try {
                        System.load(shortPathName);
                    }
                    catch (UnsatisfiedLinkError e1) {
                        try {
                            System.loadLibrary(LIBRARY_NAME);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            throw new UnsatisfiedLinkError("could not load i4jinst from " + defaultFile.getAbsolutePath() + ", " + defaultFile.isFile() + ", " + zipFile.getAbsolutePath() + ", " + zipFile.isFile() + ", " + shortPathName);
                        }
                    }
                }
            }
            Common.setWindows95(false);
            Common.setWindowsNT(InstallerUtil.isWindowsNT());
        }
    }

    static byte[] getAnsiCString(String str) {
        byte[] bytes = str.getBytes();
        byte[] terminatedBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, terminatedBytes, 0, bytes.length);
        return terminatedBytes;
    }

    static byte[] getAnsiCString(File file) {
        return Common.getAnsiCString(file.getAbsolutePath());
    }
}

