/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.WinLauncher;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.util.ArgumentStack;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.launcher.ErrorHandler;
import com.install4j.runtime.launcher.FirstRun;
import com.install4j.runtime.launcher.LauncherIntegration;
import com.install4j.runtime.launcher.LauncherVariables;
import com.install4j.runtime.launcher.LegacySplashScreen;
import com.install4j.runtime.launcher.WindowChecker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;

public class Launcher {
    private static final int POLLING_PERIOD = 1000;
    private static final int RUNNING_MULTIPLIER = 10;
    private static final int STOP_TIMEOUT_SECONDS = Integer.getInteger("install4j.daemonTimeout", 120);
    private static final int NO_PID_STARTED = 44;
    private static final int PID_STARTED = 43;
    private static File watcherFile = null;
    private static boolean service = false;
    private static String[] originalArgs;

    public static void main(String[] args) {
        block12: {
            if (!FirstRun.checkFirstRun()) {
                return;
            }
            args = Launcher.init(args);
            try {
                SplashScreenConfig splashScreenConfig;
                ArgumentStack argStack = new ArgumentStack(args);
                String method = argStack.popString();
                if (method.equals("stop")) {
                    Launcher.setStop();
                    break block12;
                }
                if (method.equals("status")) {
                    Launcher.reportStatus();
                    break block12;
                }
                String className = argStack.popString();
                boolean isGuiApplication = argStack.popBoolean();
                ErrorHandler.setIsGuiApplication(isGuiApplication);
                boolean isEvaluation = argStack.popBoolean();
                String stdErrFile = argStack.popString();
                String stdOutFile = argStack.popString();
                boolean failOnMainMethodException = argStack.popBoolean();
                try {
                    splashScreenConfig = new SplashScreenConfig().init(argStack, isEvaluation);
                    originalArgs = Launcher.getArgumentArray(argStack);
                }
                catch (Exception e) {
                    originalArgs = new String[0];
                    splashScreenConfig = new SplashScreenConfig();
                }
                SplashEngine.setJavaSplashScreenConfig(splashScreenConfig);
                Launcher.checkLegacySplashInterface();
                if (method.equals("launch")) {
                    if (!className.startsWith("com.install4j.runtime")) {
                        SplashEngine.showSplashScreen(false);
                    }
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                } else if (method.equals("start")) {
                    if (isEvaluation) {
                        System.out.println("This daemon was created with an evaluation version of install4j.");
                    }
                    Launcher.setStart();
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorHandler.reportError(e.toString());
                System.exit(1);
            }
        }
    }

    static void checkLegacySplashInterface() {
        if (SplashEngine.isShowLegacy()) {
            final LegacySplashScreen splashScreen = new LegacySplashScreen();
            SplashEngine.setLegacySplashInterface(splashScreen);
            splashScreen.setVisible(true);
            if (SplashEngine.getJavaSplashScreenConfig().isAutoOff()) {
                WindowChecker.onFirstWindowShown(new Runnable(){

                    @Override
                    public void run() {
                        splashScreen.hideScreen();
                    }
                });
            }
        }
    }

    static String[] init(String[] args) {
        args = LauncherVariables.init(Launcher.class, args);
        LauncherIntegration.checkIntegrations();
        return args;
    }

    static String[] getArgumentArray(ArgumentStack argStack) {
        int numArgs = argStack.popInt();
        if (numArgs == -1) {
            numArgs = argStack.size();
        }
        return Launcher.getArgumentArray(argStack, numArgs);
    }

    static String[] getArgumentArray(ArgumentStack argStack, int numArgs) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < numArgs; ++i) {
            String givenArg = argStack.popString();
            if (Boolean.getBoolean("i4j.vpt") && givenArg.startsWith("-J")) continue;
            ret.add(givenArg);
        }
        return ret.toArray(new String[ret.size()]);
    }

    static void reportStatus() {
        if (Launcher.isRunning()) {
            System.out.println(Launcher.getDaemonName() + " is running.");
            System.exit(0);
        } else {
            System.out.println(Launcher.getDaemonName() + " is stopped.");
            System.exit(3);
        }
    }

    private static String getDaemonName() {
        String moduleName = System.getProperty("exe4j.moduleName");
        if (moduleName != null) {
            try {
                return new File(moduleName).getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "The daemon";
    }

    public static boolean isService() {
        return service || WinLauncher.isService();
    }

    static void setStart() {
        service = true;
        File watcherFile = Launcher.getWatcherFile();
        if (Launcher.isRunning()) {
            System.out.println(Launcher.getDaemonName() + " seems to be running. Exiting. Id file: " + watcherFile);
            System.exit(1);
        }
        if (watcherFile.exists() && !watcherFile.delete()) {
            System.out.println("Could not delete id file " + watcherFile + ". Aborting.");
            System.exit(1);
        }
        boolean hasPid = Launcher.createStartFile(watcherFile);
        new StopWatcherThread(hasPid).start();
    }

    private static boolean createStartFile(File watcherFile) {
        boolean hasPid = false;
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(watcherFile));
            int pid = Launcher.getPid();
            if (pid == 0) {
                out.write(44);
            } else {
                out.write(43);
                out.writeInt(pid);
                hasPid = true;
            }
            out.close();
        }
        catch (IOException e) {
            System.out.println("Could not create id file " + watcherFile + ". Aborting.");
            System.exit(1);
        }
        return hasPid;
    }

    private static int getPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            int atPos = name.indexOf(64);
            if (atPos > 0) {
                return Integer.parseInt(name.substring(0, atPos));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRunning() {
        File watcherFile = Launcher.getWatcherFile();
        if (!watcherFile.exists()) return false;
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(watcherFile));
            try {
                int pid;
                int status = in.read();
                if (status == 43 && (pid = in.readInt()) > 0) {
                    boolean bl = Launcher.killProcess(0, pid);
                    return bl;
                }
            }
            finally {
                in.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (System.currentTimeMillis() - watcherFile.lastModified() >= 10000L) return false;
        return true;
    }

    private static boolean killProcess(int signal, int pid) throws InterruptedException, IOException {
        return Runtime.getRuntime().exec("kill -s " + signal + " " + pid).waitFor() == 0;
    }

    private static File getWatcherFile() {
        if (watcherFile == null) {
            String moduleName = System.getProperty("exe4j.moduleName");
            if (moduleName == null) {
                moduleName = ResourceHelper.getRuntimeDir().getAbsolutePath();
            } else {
                try {
                    moduleName = new File(moduleName).getCanonicalFile().getAbsolutePath();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            String watcherFileName = System.getProperty("install4j.pidDir", "/tmp") + "/i4jdaemon_" + moduleName.replace('/', '_');
            watcherFile = new File(watcherFileName);
        }
        return watcherFile;
    }

    static void setStop() {
        if (!Launcher.isRunning()) {
            System.out.println(Launcher.getDaemonName() + " is not running.");
            System.exit(0);
        }
        File watcherFile = Launcher.getWatcherFile();
        try {
            FileOutputStream fout = new FileOutputStream(watcherFile, true);
            for (int i = 0; i < 20; ++i) {
                fout.write(33);
            }
            fout.close();
        }
        catch (IOException e) {
            System.out.println("Could not stop daemon.");
            System.exit(1);
        }
        for (int i = 0; i < 2 * STOP_TIMEOUT_SECONDS && Launcher.isRunning(); ++i) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (Launcher.isRunning()) {
            System.out.println("Timeout. Daemon did not shutdown yet.");
            System.exit(1);
        } else {
            if (!watcherFile.delete() && watcherFile.exists()) {
                watcherFile.deleteOnExit();
            }
            System.out.println("Stopped.");
            System.exit(0);
        }
    }

    private Launcher() {
    }

    public static String[] appendOriginalArgs(String[] params) {
        if (originalArgs != null) {
            String[] ret = new String[params.length + originalArgs.length];
            System.arraycopy(params, 0, ret, 0, params.length);
            System.arraycopy(originalArgs, 0, ret, params.length, originalArgs.length);
            return ret;
        }
        return params;
    }

    static void setOriginalArgs(String[] originalArgs) {
        Launcher.originalArgs = originalArgs;
    }

    private static class StopWatcherThread
    extends Thread {
        private final boolean hasPid;
        private volatile boolean deleteInHook = true;
        private volatile boolean recreate = true;

        public StopWatcherThread(boolean hasPid) {
            this.hasPid = hasPid;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            final File watcherFile = Launcher.getWatcherFile();
            Runtime.getRuntime().addShutdownHook(new Thread("i4j_daemon_delete"){

                @Override
                public void run() {
                    StopWatcherThread.this.recreate = false;
                    if (StopWatcherThread.this.deleteInHook) {
                        watcherFile.delete();
                    }
                }
            });
            while (true) {
                try {
                    StopWatcherThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.recreate && !watcherFile.exists()) {
                    Launcher.createStartFile(watcherFile);
                }
                if (watcherFile.length() > 10L) {
                    if (this.hasPid) {
                        this.deleteInHook = false;
                    }
                    System.exit(0);
                    continue;
                }
                watcherFile.setLastModified(System.currentTimeMillis());
            }
        }
    }
}

