/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.update.UpdateScheduleRegistry;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.launcher.WindowChecker;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Element;

public class LauncherIntegration {
    public static final String PROPNAME_LAUNCHER_ID = "install4j.launcherId";
    public static final String FILE_NAME = "launchers.xml";
    public static final String ELEMENT_ROOT = "launcherIntegrations";
    public static final String ELEMENT_LAUNCHER = "launcher";
    public static final String ELEMENT_APPLICATION = "application";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_LAUNCH_MODE = "launchMode";
    public static final String ATTRIBUTE_LAUNCH_IN_NEW_PROCESS = "launchInNewProcess";
    public static final String ATTRIBUTE_LAUNCH_SCHEDULE = "launchSchedule";
    public static final String LAUNCH_MODE_STARTUP_SYNC = "startupSync";
    public static final String LAUNCH_MODE_STARTUP_ASNYC = "startupAsync";
    public static final String LAUNCH_MODE_FIRST_WINDOW = "startupFirstWindow";
    public static final String LAUNCH_SCHEDULE_UPDATE_SCHEDULE = "updateSchedule";
    public static final String LAUNCH_SCHEDULE_ALWAYS = "always";
    public static final String LAUNCH_SCHEDULE_FIRST_RUN = "firstRun";

    private LauncherIntegration() {
    }

    public static void checkIntegrations() {
        File file;
        String launcherId = System.getProperty(PROPNAME_LAUNCHER_ID);
        if (launcherId != null && (file = InstallerUtil.getInstallerFile(FILE_NAME)).exists()) {
            try {
                LauncherIntegration.processLauncherIntegrations(file, launcherId);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void processLauncherIntegrations(File file, String launcherId) throws IOException {
        Element root = XmlHelper.parseFile(file).getDocumentElement();
        for (Element launcherElement : XmlHelper.childElements(root)) {
            String id = XmlHelper.readAttribute(launcherElement, ATTRIBUTE_ID, "");
            if (!id.equals(launcherId)) continue;
            LauncherIntegration.processLauncherIntegrations(launcherElement);
        }
    }

    private static void processLauncherIntegrations(Element launcherElement) throws IOException {
        for (Element applicationElement : XmlHelper.childElements(launcherElement)) {
            LauncherIntegration.processLauncherIntegration(applicationElement);
        }
    }

    private static void processLauncherIntegration(Element applicationElement) throws IOException {
        final String id = XmlHelper.readAttribute(applicationElement, ATTRIBUTE_ID, "");
        String launchMode = XmlHelper.readAttribute(applicationElement, ATTRIBUTE_LAUNCH_MODE, "");
        final boolean launchInNewProcess = XmlHelper.readAttribute(applicationElement, ATTRIBUTE_LAUNCH_IN_NEW_PROCESS, false);
        String launchSchedule = XmlHelper.readAttribute(applicationElement, ATTRIBUTE_LAUNCH_SCHEDULE, "");
        if (launchSchedule.equals(LAUNCH_SCHEDULE_FIRST_RUN) ? !Boolean.getBoolean("install4j.firstRun") : launchSchedule.equals(LAUNCH_SCHEDULE_UPDATE_SCHEDULE) && !UpdateScheduleRegistry.checkAndReset()) {
            return;
        }
        if (launchMode.equals(LAUNCH_MODE_FIRST_WINDOW)) {
            WindowChecker.onFirstWindowShown(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (launchInNewProcess) {
                            ApplicationLauncher.launchApplication(id, null, false, null);
                        } else {
                            ApplicationLauncher.launchApplicationInProcess(id, null, null, ApplicationLauncher.WindowMode.FRAME, null);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            boolean blocking = launchMode.equals(LAUNCH_MODE_STARTUP_SYNC);
            if (launchInNewProcess) {
                ApplicationLauncher.launchApplication(id, null, blocking, null);
            } else {
                try {
                    if (!GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
                        GUIHelper.setLafUnconditional();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ApplicationLauncher.launchApplicationInProcess(id, null, null, ApplicationLauncher.WindowMode.FRAME, null);
                    }
                };
                if (blocking) {
                    runnable.run();
                } else {
                    new Thread(runnable).start();
                }
            }
        }
    }
}

