/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.splash.TextLineConfig;
import com.exe4j.runtime.util.ResourceHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LegacySplashScreen
extends Window
implements SplashEngine.SplashInterface {
    private JLabel lblStatus;
    private JLabel lblVersion;
    private JLabel lblSplash;

    public LegacySplashScreen() {
        super(new Frame());
        SplashScreenConfig splashScreenConfig = SplashEngine.getJavaSplashScreenConfig();
        if (splashScreenConfig.isAlwaysOnTop()) {
            this.makeAlwaysOnTop();
        }
        ImageIcon iconSplash = new ImageIcon(ResourceHelper.getImageURL(splashScreenConfig.getBitmapName()));
        this.layout(iconSplash, splashScreenConfig.getStatusLineConfig(), splashScreenConfig.getVersionLineConfig(), splashScreenConfig.isEval());
    }

    private void makeAlwaysOnTop() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                LegacySplashScreen.this.toFront();
            }
        });
    }

    private void layout(Icon iconSplash, TextLineConfig statusLineConfig, TextLineConfig versionLineConfig, boolean isEvaluation) {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel(null);
        this.lblStatus = LegacySplashScreen.createLabel(statusLineConfig);
        contentPanel.add(this.lblStatus);
        this.lblVersion = LegacySplashScreen.createLabel(versionLineConfig);
        contentPanel.add(this.lblVersion);
        this.lblSplash = new JLabel(iconSplash);
        Rectangle rectSplash = new Rectangle(new Point(0, 0), this.lblSplash.getPreferredSize());
        this.lblSplash.setBounds(rectSplash);
        contentPanel.add(this.lblSplash);
        this.add((Component)contentPanel, "Center");
        int width = this.lblSplash.getPreferredSize().width;
        int height = this.lblSplash.getPreferredSize().height;
        if (isEvaluation) {
            Font evalFont = new Font(null, 1, 12);
            JLabel evalLabel1 = new JLabel("This executable was created with");
            JLabel evalLabel2 = new JLabel("an evaluation version of install4j.");
            evalLabel1.setFont(evalFont);
            evalLabel2.setFont(evalFont);
            evalLabel1.setForeground(Color.red);
            evalLabel2.setForeground(Color.red);
            evalLabel1.setHorizontalAlignment(0);
            evalLabel2.setHorizontalAlignment(0);
            JPanel evalPanel = new JPanel(new GridLayout(2, 0, 3, 3));
            evalPanel.add(evalLabel1);
            evalPanel.add(evalLabel2);
            evalPanel.setBackground(Color.lightGray);
            evalPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.add((Component)evalPanel, "South");
            height += evalPanel.getPreferredSize().height;
            width = Math.max(width, evalPanel.getPreferredSize().width);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        this.setBounds(x, y, width, height);
    }

    private static JLabel createLabel(TextLineConfig config) {
        String text = config.getText();
        if (text.length() == 0) {
            text = " ";
        }
        JLabel ret = new JLabel(text);
        ret.setOpaque(false);
        ret.setForeground(config.getFontColor());
        Font font = ret.getFont();
        ret.setFont(font.deriveFont(config.getFontStyle(), (int)((double)config.getFontSize() * 1.2)));
        Rectangle rectText = new Rectangle(config.getPosition(), new Dimension(600, ret.getPreferredSize().height));
        ret.setBounds(rectText);
        return ret;
    }

    @Override
    public void hideScreen() {
        LegacySplashScreen.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LegacySplashScreen.this.isVisible()) {
                    LegacySplashScreen.this.setVisible(false);
                    LegacySplashScreen.this.dispose();
                }
            }
        });
    }

    @Override
    public void showScreen() {
        this.setVisible(true);
    }

    @Override
    public void writeMessage(final String message) {
        LegacySplashScreen.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LegacySplashScreen.this.isVisible()) {
                    LegacySplashScreen.this.lblStatus.setText(message);
                }
            }
        });
    }

    private static void invokeLater(final Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        }
    }
}

