/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.runtime.launcher.WindowChecker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class SwtWindowChecker
extends WindowChecker {
    private ThreadGroup rootThreadGroup = Thread.currentThread().getThreadGroup().getParent();

    public SwtWindowChecker(Runnable runnable) {
        super(runnable);
        while (this.rootThreadGroup.getParent() != null) {
            this.rootThreadGroup = this.rootThreadGroup.getParent();
        }
    }

    @Override
    protected boolean checkExecute() {
        return this.checkThreads(this.rootThreadGroup, 0);
    }

    public boolean checkThreads(ThreadGroup threadGroup, int level) {
        int threadCount = threadGroup.activeCount();
        Thread[] threads = new Thread[2 * threadCount];
        threadCount = threadGroup.enumerate(threads, false);
        for (int i = 0; i < threadCount; ++i) {
            Thread thread = threads[i];
            if (!this.checkThread(thread)) continue;
            return true;
        }
        int groupCount = threadGroup.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[2 * groupCount];
        groupCount = threadGroup.enumerate(groups, false);
        for (int i = 0; i < groupCount; ++i) {
            try {
                if (!this.checkThreads(groups[i], level + 1)) continue;
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean checkThread(Thread thread) {
        final Display display = Display.findDisplay((Thread)thread);
        if (display != null) {
            final boolean[] result = new boolean[1];
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell[] shells;
                    for (Shell shell : shells = display.getShells()) {
                        if (!shell.isVisible()) continue;
                        result[0] = true;
                        return;
                    }
                }
            });
            return result[0];
        }
        return false;
    }
}

