/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.util.ArgumentStack;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.launcher.ErrorHandler;
import com.install4j.runtime.launcher.FirstRun;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.LauncherVariables;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Properties;

public class UnixLauncher {
    public static void main(String[] args) {
        if (!FirstRun.checkFirstRun()) {
            return;
        }
        args = Launcher.init(args);
        try {
            ArgumentStack argStack = new ArgumentStack(args);
            String method = argStack.popString();
            if (method.equals("stop")) {
                Launcher.setStop();
            } else if (method.equals("status")) {
                Launcher.reportStatus();
            } else {
                String configId = argStack.popString();
                String stdErrFile = argStack.popString();
                String stdOutFile = argStack.popString();
                String className = argStack.popString();
                LauncherEngine.setProperties(UnixLauncher.readProperties(configId));
                boolean isGuiApplication = LauncherEngine.getBooleanProperty(162);
                ErrorHandler.setIsGuiApplication(isGuiApplication);
                boolean failOnMainMethodException = LauncherEngine.getBooleanProperty(106);
                String[] originalArgs = Launcher.getArgumentArray(argStack, argStack.size());
                Launcher.setOriginalArgs(originalArgs);
                SplashEngine.setJavaSplashScreenConfig(new SplashScreenConfig().initFromLauncherEngine());
                if (method.equals("launch")) {
                    UnixLauncher.checkWarning();
                    if (!className.startsWith("com.install4j.runtime")) {
                        SplashEngine.showSplashScreen(false);
                    }
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                } else if (method.equals("start")) {
                    Launcher.setStart();
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                } else if (method.equals("run")) {
                    UnixLauncher.checkWarning();
                    LauncherEngine.launch(className, originalArgs, "", "", failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                } else if (method.equals("run-redirect")) {
                    UnixLauncher.checkWarning();
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.reportError(e.toString());
            System.exit(1);
        }
    }

    private static void checkWarning() {
        if (LauncherEngine.getBooleanProperty(148)) {
            System.out.println("This launcher was created with an evaluation version of install4j.");
        }
    }

    private static Properties readProperties(String configId) {
        if (configId.equals("0")) {
            Properties properties = new Properties();
            properties.setProperty(String.valueOf(162), String.valueOf(true));
            return properties;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(InstallerUtil.getInstallerFile(configId + ".lprop")));
            Properties properties = new Properties();
            properties.load(in);
            return LauncherVariables.replaceVariables(properties);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new Properties();
        }
    }
}

