/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.api.beans.Anchor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.KeyboardUtil;
import com.install4j.runtime.util.MaximizedLayeredPane;
import com.install4j.runtime.util.PartialLineBorder;
import com.install4j.runtime.wizard.WizardBase;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public abstract class StandardScreen
extends WizardScreen
implements ActionListener {
    private static final int HORIZONTAL_BUTTON_SPACER = 10;
    private static final Color DEFAULT_BANNER_BACKGROUND = new Color(34, 79, 153);
    private JButton btnPrevious;
    private JButton btnForward;
    private JButton btnCancel;
    private List<JComponent> revalidationComponents;
    private DisplayTextArea titleLabel;
    private DisplayTextArea subtitleLabel;

    public StandardScreen(WizardBase wizardBase) {
        super(wizardBase);
    }

    protected abstract void addScreenContent(JPanel var1, GridBagConstraints var2);

    protected abstract String getTitle();

    protected abstract String getSubTitle();

    protected abstract Icon getBannerIcon();

    protected abstract Anchor getBannerImageAnchor();

    protected abstract Color getHeaderBackgroundColor();

    protected abstract Color getHeaderForegroundColor();

    protected abstract Icon getHeaderIcon();

    protected abstract boolean isHeaderIconOverlap();

    protected abstract Anchor getHeaderIconAnchor();

    protected abstract JButton createCancelButton();

    protected abstract JButton createForwardButton();

    protected abstract JButton createPreviousButton();

    protected void initScreen() {
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    protected JButton getPreviousButton() {
        return this.btnPrevious;
    }

    protected JButton getForwardButton() {
        return this.btnForward;
    }

    protected JButton getCancelButton() {
        return this.btnCancel;
    }

    protected void setupControls() {
        this.revalidationComponents = new ArrayList<JComponent>();
        this.btnPrevious = this.createPreviousButton();
        this.btnForward = this.createForwardButton();
        this.btnCancel = this.createCancelButton();
    }

    protected void setupComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        if (this.isBannerPainted()) {
            Anchor imageAnchor = this.getBannerImageAnchor();
            Icon bannerIcon = this.getBannerIcon();
            JLabel indexBackground = new JLabel(bannerIcon);
            JPanel imagePanel = new JPanel();
            if (imageAnchor == Anchor.NORTH || imageAnchor == Anchor.SOUTH) {
                imagePanel.setLayout(new BorderLayout());
                imagePanel.add((Component)indexBackground, imageAnchor == Anchor.NORTH ? "North" : "South");
            } else {
                imagePanel.setLayout(new GridBagLayout());
                GridBagConstraints gc = new GridBagConstraints();
                gc.weighty = 1.0;
                gc.weightx = 1.0;
                gc.anchor = this.getBannerImageAnchor().getValue();
                imagePanel.add((Component)indexBackground, gc);
            }
            imagePanel.setOpaque(true);
            imagePanel.setBackground(this.getBannerBackground());
            imagePanel.setPreferredSize(new Dimension(bannerIcon.getIconWidth(), 0));
            mainPanel.add((Component)imagePanel, "West");
        } else if (this.hasTitlePanel()) {
            mainPanel.add((Component)this.createTitlePanel(), "North");
        }
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = 1.0;
        mainPanel.add((Component)contentPanel, "Center");
        gc.gridwidth = this.getMaxGridWidth();
        gc.fill = 2;
        gc.anchor = 18;
        if (this.isBannerPainted()) {
            gc.insets = new Insets(5, 0, 0, 5);
            contentPanel.setBackground(Color.white);
            contentPanel.setOpaque(true);
        } else {
            gc.insets = new Insets(5, 15, 0, 20);
        }
        if (this.isBannerPainted()) {
            this.titleLabel = this.createTitleLabel(4, true, this.getTitle());
            contentPanel.add((Component)this.titleLabel, gc);
            ++gc.gridy;
            contentPanel.add((Component)this.createSeparator(false), gc);
            ++gc.gridy;
        }
        this.addScreenContent(contentPanel, gc);
        if (this.needsSpacer()) {
            gc.weighty = 1.0;
            gc.fill = 1;
            JPanel spacerPanel = new JPanel();
            spacerPanel.setBackground(contentPanel.getBackground());
            spacerPanel.setOpaque(false);
            contentPanel.add((Component)spacerPanel, gc);
            ++gc.gridy;
        }
        if (this.hasNavigationPanel()) {
            JPanel navigationPanel = this.createNavigationPanel(this.createButtonBox(), true);
            mainPanel.add((Component)navigationPanel, "South");
        }
        return mainPanel;
    }

    protected boolean hasTitlePanel() {
        return true;
    }

    protected Color getBannerBackground() {
        return DEFAULT_BANNER_BACKGROUND;
    }

    protected void setupEventHandlers() {
        this.btnPrevious.addActionListener(this);
        this.btnForward.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                for (JComponent revalidationComponent : StandardScreen.this.revalidationComponents) {
                    revalidationComponent.invalidate();
                }
                StandardScreen.this.validate();
            }
        });
        KeyboardUtil.addAccelerator(1, this.btnCancel, this, this, 27, 0);
        KeyboardUtil.addAccelerator(1, this.btnForward, this, this, 39, 8);
        KeyboardUtil.addAccelerator(1, this.btnPrevious, this, this, 37, 8);
    }

    protected boolean isBannerPainted() {
        return false;
    }

    protected int getMaxGridWidth() {
        return 1;
    }

    protected boolean needsSpacer() {
        return true;
    }

    protected boolean hasNavigationPanel() {
        return true;
    }

    protected Box createButtonBox() {
        Box buttonBoxNavigation = ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnPrevious, this.btnForward}, 0);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(buttonBoxNavigation);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.btnCancel);
        return buttonBox;
    }

    protected boolean checkCompleted() {
        return true;
    }

    protected void addDisplayTextArea(String text, JPanel panel, GridBagConstraints gc) {
        int oldFill = gc.fill;
        double oldWeightx = gc.weightx;
        gc.fill = 2;
        gc.weightx = 1.0;
        DisplayTextArea dtxa = new DisplayTextArea();
        dtxa.setText(text);
        panel.add((Component)dtxa, gc);
        this.revalidationComponents.add(dtxa);
        ++gc.gridy;
        gc.fill = oldFill;
        gc.weightx = oldWeightx;
    }

    protected JPanel createBorderPanel(String title, LayoutManager layoutManager) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        if (layoutManager != null) {
            panel.setLayout(layoutManager);
        }
        return panel;
    }

    protected void cancel() {
        this.getWizardBase().cancel();
    }

    protected void updateTitleAndSubtitle() {
        if (this.titleLabel != null) {
            this.titleLabel.setText(this.getTitle());
        }
        if (this.subtitleLabel != null) {
            this.subtitleLabel.setText(this.getSubTitle());
        }
    }

    private JComponent createTitlePanel() {
        JPanel wrapperPanel = new JPanel(new BorderLayout());
        MaximizedLayeredPane layeredPane = new MaximizedLayeredPane();
        JPanel frontPanel = this.createTitleFrontPanel(!this.isHeaderIconOverlap());
        layeredPane.add((Component)frontPanel, JLayeredPane.PALETTE_LAYER);
        if (this.isHeaderIconOverlap()) {
            JPanel backPanel = new JPanel(new GridBagLayout());
            backPanel.setBackground(this.getHeaderBackgroundColor());
            backPanel.setOpaque(true);
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            gc.anchor = this.getHeaderIconAnchor().getValue();
            backPanel.add((Component)new JLabel(this.getHeaderIcon()), gc);
            layeredPane.add((Component)backPanel, JLayeredPane.DEFAULT_LAYER);
        }
        wrapperPanel.add((Component)layeredPane, "Center");
        wrapperPanel.setBorder(new PartialLineBorder(GUIHelper.getSeparatorColor(), 1, 2));
        return wrapperPanel;
    }

    private JPanel createTitleFrontPanel(boolean addIcon) {
        JPanel panel = new JPanel(new GridBagLayout());
        if (addIcon) {
            panel.setBackground(this.getHeaderBackgroundColor());
            panel.setOpaque(true);
        } else {
            panel.setOpaque(false);
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.anchor = 18;
        gc.insets = new Insets(5, 15, 0, 5);
        this.titleLabel = this.applyHeaderForeground(this.createTitleLabel(0, true, this.getTitle()));
        panel.add((Component)this.titleLabel, gc);
        gc.gridy = 1;
        gc.insets = new Insets(3, 25, 5, 5);
        this.subtitleLabel = this.applyHeaderForeground(this.createTitleLabel(0, false, this.getSubTitle()));
        panel.add((Component)this.subtitleLabel, gc);
        gc.gridy = 0;
        gc.gridx = 1;
        gc.gridheight = 2;
        gc.insets = new Insets(0, 13, 0, 0);
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 13;
        if (addIcon) {
            panel.add((Component)new JLabel(this.getHeaderIcon()), gc);
        }
        return panel;
    }

    private DisplayTextArea applyHeaderForeground(DisplayTextArea titleLabel) {
        Color foreground = this.getHeaderForegroundColor();
        if (foreground != null) {
            titleLabel.setForeground(foreground);
        }
        return titleLabel;
    }

    private DisplayTextArea createTitleLabel(int fontSizeDiff, boolean bold, String text) {
        DisplayTextArea titleLabel = new DisplayTextArea();
        titleLabel.setText(text);
        Font standardFont = titleLabel.getFont();
        if (bold) {
            Font titleFont = new Font("Dialog", 1, standardFont.getSize() + fontSizeDiff);
            titleLabel.setFont(titleFont);
        }
        this.revalidationComponents.add(titleLabel);
        return titleLabel;
    }
}

