/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.internal;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sonatype.nexus.common.entity.AbstractEntity;

public class ClusteredModelVersions
extends AbstractEntity
implements Iterable<Map.Entry<String, String>> {
    private Map<String, String> modelVersions = new HashMap<String, String>();
    private boolean dirty;

    public Map<String, String> getModelVersions() {
        return this.modelVersions;
    }

    public void setModelVersions(Map<String, String> modelVersions) {
        this.modelVersions = (Map)Preconditions.checkNotNull(modelVersions);
    }

    public String get(String model) {
        Preconditions.checkNotNull((Object)model);
        return this.modelVersions.get(model);
    }

    public void put(String model, String version) {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)version);
        String oldVersion = this.modelVersions.put(model, version);
        this.dirty = this.dirty || !version.equals(oldVersion);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.modelVersions.entrySet().iterator();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.modelVersions;
    }
}

