/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.upgrade.Checkpoint;
import org.sonatype.nexus.common.upgrade.Upgrade;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.upgrade.UpgradeService;
import org.sonatype.nexus.upgrade.internal.ModelVersionStore;
import org.sonatype.nexus.upgrade.internal.UpgradeManager;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.UPGRADE)
@Singleton
public class UpgradeServiceImpl
extends StateGuardLifecycleSupport
implements UpgradeService {
    private static final String BANNER = "\n- - - - - - - - - - - - - - - - - - - - - - - - -\n{}\n- - - - - - - - - - - - - - - - - - - - - - - - -";
    private final UpgradeManager upgradeManager;
    private final ModelVersionStore modelVersionStore;
    private final NodeAccess nodeAccess;
    private Map<String, String> modelVersions;

    @Inject
    public UpgradeServiceImpl(UpgradeManager upgradeManager, ModelVersionStore modelVersionStore, NodeAccess nodeAccess) {
        this.upgradeManager = (UpgradeManager)((Object)Preconditions.checkNotNull((Object)((Object)upgradeManager)));
        this.modelVersionStore = (ModelVersionStore)((Object)Preconditions.checkNotNull((Object)((Object)modelVersionStore)));
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected void doStart() throws Exception {
        this.modelVersionStore.start();
        this.modelVersions = this.validate(this.modelVersionStore.load());
        List<Upgrade> upgrades = this.upgradeManager.selectUpgrades(this.modelVersions);
        if (upgrades.isEmpty()) {
            return;
        }
        try {
            if (this.nodeAccess.isFreshNode()) {
                this.doInventory(upgrades);
            } else {
                this.doUpgrade(upgrades);
            }
        }
        catch (RuntimeException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), Exception.class);
            throw e;
        }
        this.modelVersionStore.save(this.modelVersions);
    }

    protected void doStop() throws Exception {
        this.modelVersionStore.stop();
    }

    private void doInventory(List<Upgrade> upgrades) {
        Object inventoryFilter = Predicates.alwaysTrue();
        if (!this.nodeAccess.isOldestNode()) {
            Set<String> localModels = this.upgradeManager.getLocalModels();
            inventoryFilter = upgrade -> localModels.contains(upgrade.model());
        }
        upgrades.stream().map(this.upgradeManager::getMetadata).filter((Predicate<Upgrades>)inventoryFilter).forEach(upgrade -> {
            String string = this.modelVersions.put(upgrade.model(), upgrade.to());
        });
    }

    private void doUpgrade(List<Upgrade> upgrades) {
        List<Checkpoint> checkpoints = this.upgradeManager.selectCheckpoints(upgrades);
        this.log.info(BANNER, (Object)"Begin upgrade");
        checkpoints.forEach(this.begin());
        try {
            this.log.info(BANNER, (Object)"Apply upgrade");
            upgrades.forEach(this.apply());
            this.log.info(BANNER, (Object)"Commit upgrade");
            checkpoints.forEach(this.commit());
        }
        catch (Throwable e) {
            this.log.warn(BANNER, (Object)"Rollback upgrade");
            checkpoints.forEach(this.rollback());
            this.log.warn(BANNER, (Object)"Upgrade failed");
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        checkpoints.forEach(this.end());
        this.log.info(BANNER, (Object)"Upgrade complete");
    }

    private Map<String, String> validate(Map<String, String> modelVersions) {
        boolean failed = false;
        for (Map.Entry<String, String> entry : this.upgradeManager.latestKnownModelVersions().entrySet()) {
            String current = modelVersions.getOrDefault(entry.getKey(), "1.0");
            String latest = entry.getValue();
            if (VersionComparator.INSTANCE.compare(latest, current) >= 0) continue;
            this.log.error("The database model for {} is {}, but the latest supported by this version of nexus is {}", new Object[]{entry.getKey(), current, latest});
            failed = true;
        }
        if (failed) {
            throw new IllegalStateException("Incompatible sonatype-work database model detected. Will result in failure to launch. Shutting down.");
        }
        return modelVersions;
    }

    private Consumer<Checkpoint> begin() {
        return checkpoint -> {
            String model = this.upgradeManager.getModel((Checkpoint)checkpoint);
            try {
                this.log.info("Checkpoint {}", (Object)model);
                checkpoint.begin(this.modelVersions.getOrDefault(model, "1.0"));
            }
            catch (Throwable e) {
                this.log.warn("Problem checkpointing {}", (Object)model, (Object)e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private Consumer<Upgrade> apply() {
        return upgrade -> {
            Upgrades metadata = this.upgradeManager.getMetadata((Upgrade)upgrade);
            String detail = String.format("%s from %s to %s", metadata.model(), metadata.from(), metadata.to());
            try {
                this.log.info("Upgrade {}", (Object)detail);
                upgrade.apply();
                this.modelVersions.put(metadata.model(), metadata.to());
            }
            catch (Throwable e) {
                this.log.warn("Problem upgrading {}", (Object)detail, (Object)e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private Consumer<Checkpoint> commit() {
        return checkpoint -> {
            String model = this.upgradeManager.getModel((Checkpoint)checkpoint);
            try {
                this.log.info("Commit {}", (Object)model);
                checkpoint.commit();
            }
            catch (Throwable e) {
                this.log.warn("Problem committing {}", (Object)model, (Object)e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private Consumer<Checkpoint> rollback() {
        return checkpoint -> {
            String model = this.upgradeManager.getModel((Checkpoint)checkpoint);
            try {
                this.log.info("Rolling back {}", (Object)model);
                checkpoint.rollback();
            }
            catch (Throwable e) {
                this.log.warn("Problem rolling back {}", (Object)model, (Object)e);
            }
        };
    }

    private Consumer<Checkpoint> end() {
        return checkpoint -> {
            String model = this.upgradeManager.getModel((Checkpoint)checkpoint);
            try {
                this.log.info("Cleaning up {}", (Object)model);
                checkpoint.end();
            }
            catch (Throwable e) {
                this.log.warn("Problem cleaning up {}", (Object)model, (Object)e);
            }
        };
    }
}

