/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrade;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.upgrade.internal.UpgradeDependency;
import org.sonatype.nexus.upgrade.internal.UpgradePoint;
import org.sonatype.nexus.upgrade.plan.Dependency;
import org.sonatype.nexus.upgrade.plan.DependencySource;

public class UpgradeStep
implements UpgradePoint,
DependencySource<UpgradePoint> {
    private final Upgrade upgrade;
    private final Upgrades upgrades;
    private final DependsOn[] dependsOn;

    public UpgradeStep(Upgrade upgrade) {
        this.upgrade = (Upgrade)Preconditions.checkNotNull((Object)upgrade);
        this.upgrades = upgrade.getClass().getAnnotation(Upgrades.class);
        this.dependsOn = (DependsOn[])upgrade.getClass().getAnnotationsByType(DependsOn.class);
        Preconditions.checkArgument((this.upgrades != null ? 1 : 0) != 0, (String)"%s is not annotated with @Upgrades", upgrade.getClass());
    }

    @Nullable
    public static Upgrade unwrap(DependencySource<UpgradePoint> source) {
        return source instanceof UpgradeStep ? ((UpgradeStep)source).upgrade : null;
    }

    public String getModel() {
        return this.upgrades.model();
    }

    public String getVersion() {
        return this.upgrades.to();
    }

    @Override
    public List<Dependency<UpgradePoint>> getDependencies() {
        List dependencies = Arrays.stream(this.dependsOn).map(dep -> new UpgradeDependency(dep.model(), dep.version())).collect(Collectors.toCollection(ArrayList::new));
        dependencies.add(new UpgradeDependency(this.upgrades.model(), this.upgrades.from()));
        return dependencies;
    }

    @Override
    public boolean satisfies(String model, String version) {
        return model.equals(this.getModel()) && version.equals(this.getVersion());
    }

    public String toString() {
        return String.valueOf(this.upgrade.getClass().getSimpleName()) + '{' + "upgrades=" + this.upgrades + ", dependsOn=" + Arrays.toString(this.dependsOn) + '}';
    }
}

