/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.app;

import java.util.Comparator;
import java.util.regex.Pattern;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

public class VersionComparator
implements Comparator<String> {
    private static final GenericVersionScheme VERSION_SCHEME = new GenericVersionScheme();
    public static final Comparator<String> INSTANCE = new VersionComparator();
    private static final Pattern VERSION_RE = Pattern.compile("^\\d+([._-][0-9a-z]+)*$", 2);

    public static Version version(String version) {
        try {
            return VERSION_SCHEME.parseVersion(version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int compare(String o1, String o2) {
        boolean secondObjectLooksLikeVersion;
        boolean firstObjectLooksLikeVersion = this.isVersionLike(o1);
        if (firstObjectLooksLikeVersion ^ (secondObjectLooksLikeVersion = this.isVersionLike(o2))) {
            if (firstObjectLooksLikeVersion) {
                return 1;
            }
            return -1;
        }
        if (firstObjectLooksLikeVersion) {
            Version v1 = VersionComparator.version(o1);
            Version v2 = VersionComparator.version(o2);
            return v1.compareTo((Object)v2);
        }
        return o1.compareTo(o2);
    }

    private boolean isVersionLike(String version) {
        return VERSION_RE.matcher(version).matches();
    }
}

