/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.collect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.AttributesMap;

public class NestedAttributesMap
extends AttributesMap {
    @VisibleForTesting
    static final String SEPARATOR = "::";
    @Nullable
    private final NestedAttributesMap parent;
    private final String key;

    public NestedAttributesMap(String key, Map<String, Object> backing) {
        this(null, key, backing);
    }

    @VisibleForTesting
    NestedAttributesMap(@Nullable NestedAttributesMap parent, String key, Map<String, Object> backing) {
        super(backing);
        this.parent = parent;
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    @Nullable
    public NestedAttributesMap getParent() {
        return this.parent;
    }

    @VisibleForTesting
    String getParentKey() {
        if (this.parent != null) {
            if (this.parent.parent != null) {
                return String.valueOf(this.parent.getParentKey()) + SEPARATOR + this.parent.getKey();
            }
            return this.parent.getKey();
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    @VisibleForTesting
    String getQualifiedKey() {
        if (this.parent != null) {
            return String.valueOf(this.getParentKey()) + SEPARATOR + this.key;
        }
        return this.key;
    }

    @Override
    protected String missingKeyMessage(String key) {
        return "Missing: {" + this.getQualifiedKey() + "} " + key;
    }

    protected Map<String, Object> newChildBacking() {
        return Maps.newHashMap();
    }

    public NestedAttributesMap child(String name) {
        Preconditions.checkNotNull((Object)name);
        Object child = this.backing.get(name);
        if (child == null) {
            child = this.newChildBacking();
            this.backing.put(name, child);
        } else {
            Preconditions.checkState((boolean)(child instanceof Map), (String)"child '%s' not a Map", (Object)name);
        }
        return new NestedAttributesMap(this, name, (Map)child);
    }

    @Override
    @Nullable
    public Object set(String key, @Nullable Object value) {
        Preconditions.checkState((!(value instanceof Map) ? 1 : 0) != 0, (Object)"Use child() to set a map value");
        return super.set(key, value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "parent=" + this.getParentKey() + ", key='" + this.key + '\'' + ", backing=" + this.backing + '}';
    }
}

