/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.decorator;

import javax.annotation.Nullable;
import org.sonatype.nexus.common.decorator.DecoratedObject;

public class DecoratorUtils {
    private DecoratorUtils() {
    }

    @Nullable
    public static <T> T getDecoratedEntity(Object decoratedObject, Class<T> clazz) {
        if (decoratedObject.getClass().isAssignableFrom(clazz)) {
            return (T)decoratedObject;
        }
        if (!(decoratedObject instanceof DecoratedObject)) {
            return null;
        }
        Object wrappedObject = ((DecoratedObject)decoratedObject).getWrappedObject();
        if (wrappedObject.getClass().isAssignableFrom(clazz)) {
            return wrappedObject;
        }
        if (wrappedObject instanceof DecoratedObject) {
            return DecoratorUtils.getDecoratedEntity(wrappedObject, clazz);
        }
        return null;
    }
}

