/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class EncodingUtil {
    private EncodingUtil() {
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 encoding is not supported on this system.", e);
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 encoding is not supported on this system.", e);
        }
    }

    public static String[] urlDecode(String ... strings) {
        String[] result = null;
        if (strings != null) {
            result = new String[strings.length];
            int i = 0;
            while (i < strings.length) {
                result[i] = EncodingUtil.urlDecode(strings[i]);
                ++i;
            }
        }
        return result;
    }
}

