/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeConverter;
import java.lang.annotation.Annotation;
import org.eclipse.sisu.inject.TypeArguments;

public abstract class TypeConverterSupport<T>
extends AbstractModule
implements TypeConverter {
    private boolean bound;

    public void configure() {
        if (!this.bound) {
            this.bind(Key.get(TypeConverterSupport.class, (Annotation)Names.named((String)((Object)((Object)this)).getClass().getName()))).toInstance((Object)this);
            this.bound = true;
        }
        TypeLiteral superType = TypeLiteral.get(((Object)((Object)this)).getClass()).getSupertype(TypeConverterSupport.class);
        this.convertToTypes(Matchers.only((Object)TypeArguments.get((TypeLiteral)superType, (int)0)), this);
    }

    public Object convert(String value, TypeLiteral<?> toType) {
        try {
            return this.doConvert(value, toType);
        }
        catch (Exception e) {
            throw new ProvisionException(String.format("Unable to convert value: %s due to: %s", value, e));
        }
    }

    protected abstract Object doConvert(String var1, TypeLiteral<?> var2) throws Exception;
}

