/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import java.util.concurrent.TimeUnit;
import org.sonatype.goodies.common.Time;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;

public abstract class CooperationFactorySupport
extends LifecycleSupport
implements CooperationFactory {
    @Override
    public CooperationFactory.Builder configure() {
        return new MutableConfig();
    }

    protected abstract Cooperation build(String var1, Config var2);

    public static class Config {
        protected int majorTimeoutSeconds = 0;
        protected int minorTimeoutSeconds = 0;
        protected int threadsPerKey = 0;

        public Time majorTimeout() {
            return new Time((long)this.majorTimeoutSeconds, TimeUnit.SECONDS);
        }

        public Time minorTimeout() {
            return new Time((long)this.minorTimeoutSeconds, TimeUnit.SECONDS);
        }

        public int threadsPerKey() {
            return this.threadsPerKey;
        }

        protected Config copy() {
            Config copy = new Config();
            copy.majorTimeoutSeconds = this.majorTimeoutSeconds;
            copy.minorTimeoutSeconds = this.minorTimeoutSeconds;
            copy.threadsPerKey = this.threadsPerKey;
            return copy;
        }
    }

    private final class MutableConfig
    extends Config
    implements CooperationFactory.Builder {
        private MutableConfig() {
        }

        @Override
        public CooperationFactory.Builder majorTimeout(Time majorTimeout) {
            this.majorTimeoutSeconds = majorTimeout.toSecondsI();
            return this;
        }

        @Override
        public CooperationFactory.Builder minorTimeout(Time minorTimeout) {
            this.minorTimeoutSeconds = minorTimeout.toSecondsI();
            return this;
        }

        @Override
        public CooperationFactory.Builder threadsPerKey(int threadsPerKey) {
            this.threadsPerKey = threadsPerKey;
            return this;
        }

        @Override
        public Cooperation build(String id) {
            return CooperationFactorySupport.this.build(id, this.copy());
        }
    }
}

