/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.io.CooperatingFuture;
import org.sonatype.nexus.common.io.ScopedCooperationFactorySupport;

@Named(value="local")
@Singleton
public class LocalCooperationFactory
extends ScopedCooperationFactorySupport {
    private final ConcurrentMap<String, CooperatingFuture<?>> localFutures = new ConcurrentHashMap();

    @Override
    protected <T> CooperatingFuture<T> beginCooperation(String scopedKey, CooperatingFuture<T> future) {
        return this.localFutures.putIfAbsent(scopedKey, future);
    }

    @Override
    protected <T> void endCooperation(String scopedKey, CooperatingFuture<T> future) {
        this.localFutures.remove(scopedKey, future);
    }

    @Override
    protected Stream<CooperatingFuture<?>> streamFutures(String scope) {
        return this.localFutures.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(scope)).map(Map.Entry::getValue);
    }
}

