/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public final class NetworkHelper {
    private NetworkHelper() {
    }

    public static String findLocalHostAddress() throws Exception {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface intf = interfaces.nextElement();
            if (!intf.isUp() || intf.isLoopback() || intf.isPointToPoint() || intf.isVirtual()) continue;
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                if (!addr.isSiteLocalAddress() || addr.isLoopbackAddress()) continue;
                return addr.getHostAddress();
            }
        }
        return InetAddress.getLocalHost().getHostAddress();
    }
}

