/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    private final ClassLoader loader;

    public ObjectInputStreamWithClassLoader(InputStream inputStream, ClassLoader loader) throws IOException {
        super(inputStream);
        this.loader = (ClassLoader)Preconditions.checkNotNull((Object)loader);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        return Class.forName(classDesc.getName(), false, this.loader);
    }
}

