/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SanitizingJsonOutputStream
extends PipedOutputStream {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonGenerator generator;
    private final Thread pipe;
    private IOException ioException;

    public SanitizingJsonOutputStream(OutputStream out, Collection<String> fields, String replacement) throws IOException {
        this.generator = new SanitizingJsonGenerator(jsonFactory.createGenerator(out), fields, replacement);
        PipedInputStream pipedInput = new PipedInputStream(this);
        this.pipe = new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JsonParser parser = jsonFactory.createParser((InputStream)pipedInput);){
                    parser.nextToken();
                    this.generator.copyCurrentStructure(parser);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.ioException = e;
            }
        });
        this.pipe.start();
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            try {
                this.pipe.join();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        finally {
            this.generator.close();
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
    }

    private static class SanitizingJsonGenerator
    extends JsonGeneratorDelegate {
        private final Set<String> fields;
        private final String replacement;
        private int skip;

        public SanitizingJsonGenerator(JsonGenerator delegate, Collection<String> fields, String replacement) {
            super(delegate, false);
            this.fields = new HashSet<String>(fields);
            this.replacement = (String)Preconditions.checkNotNull((Object)replacement);
        }

        public void copyCurrentStructure(JsonParser jp) throws IOException {
            if (jp.hasTokenId(5) && this.fields.contains(jp.getCurrentName())) {
                ++this.skip;
                super.copyCurrentStructure(jp);
                --this.skip;
            } else {
                super.copyCurrentStructure(jp);
            }
        }

        public void copyCurrentEvent(JsonParser jp) throws IOException {
            boolean shouldReplace;
            boolean bl = shouldReplace = this.skip > 0 && !jp.getText().isEmpty();
            if (shouldReplace) {
                this.writeString(this.replacement);
            } else {
                super.copyCurrentEvent(jp);
            }
        }
    }
}

