/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.property;

public class SystemPropertiesHelper {
    private SystemPropertiesHelper() {
    }

    public static int getInteger(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static long getLong(String key, long defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static String getString(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }
}

