/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.sequence;

import org.sonatype.nexus.common.sequence.NumberSequence;

public class FibonacciNumberSequence
implements NumberSequence {
    private final long startA;
    private final long startB;
    private long a;
    private long b;

    public FibonacciNumberSequence() {
        this(1L);
    }

    public FibonacciNumberSequence(long start) {
        this(start, start);
    }

    public FibonacciNumberSequence(long startA, long startB) {
        this.startA = startA;
        this.startB = startB;
        this.reset();
    }

    @Override
    public long next() {
        long res = this.a;
        this.a = this.b;
        this.b = res + this.b;
        return res;
    }

    @Override
    public long prev() {
        long tmp = this.b;
        this.b = this.a;
        this.a = tmp - this.b;
        return this.a;
    }

    @Override
    public long peek() {
        return this.a;
    }

    @Override
    public void reset() {
        this.a = this.startA;
        this.b = this.startB;
    }
}

