/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.stateguard;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.stateguard.Guard;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.MethodInvocationAction;
import org.sonatype.nexus.common.stateguard.StateGuard;
import org.sonatype.nexus.common.stateguard.StateGuardAware;

public class GuardedInterceptor
extends ComponentSupport
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        assert (invocation != null);
        Object target = invocation.getThis();
        Method method = invocation.getMethod();
        Preconditions.checkState((boolean)(target instanceof StateGuardAware), (String)"Invocation target (%s) does not implement: %s", target.getClass(), StateGuardAware.class);
        StateGuard states = ((StateGuardAware)target).getStateGuard();
        Preconditions.checkState((states != null ? 1 : 0) != 0);
        Guarded config = method.getAnnotation(Guarded.class);
        Preconditions.checkState((config != null ? 1 : 0) != 0);
        Guard guard = states.guard(config.by());
        this.log.trace("Invoking: {} -> {}", (Object)guard, (Object)method);
        try {
            return guard.run(new MethodInvocationAction(invocation));
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

