/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.stateguard;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Locks;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.stateguard.Action;
import org.sonatype.nexus.common.stateguard.Guard;
import org.sonatype.nexus.common.stateguard.InvalidStateException;
import org.sonatype.nexus.common.stateguard.Transition;

public class StateGuard {
    private final Logger log;
    private final ReadWriteLock readWriteLock;
    @Nullable
    private final String failure;
    private String current;

    StateGuard(Logger log, ReadWriteLock readWriteLock, String initial, @Nullable String failure) {
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.readWriteLock = (ReadWriteLock)Preconditions.checkNotNull((Object)readWriteLock);
        this.current = (String)Preconditions.checkNotNull((Object)initial);
        this.failure = failure;
    }

    public String getCurrent() {
        Lock lock = Locks.read((ReadWriteLock)this.readWriteLock);
        try {
            String string = this.current;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean is(String state) {
        Lock lock = Locks.read((ReadWriteLock)this.readWriteLock);
        try {
            boolean bl = this.current.equals(state);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void ensure(String ... allowed) {
        Preconditions.checkNotNull((Object)allowed);
        Preconditions.checkArgument((allowed.length != 0 ? 1 : 0) != 0);
        Lock lock = Locks.read((ReadWriteLock)this.readWriteLock);
        try {
            this._ensure(allowed);
        }
        finally {
            lock.unlock();
        }
    }

    private void _ensure(String[] allowed) {
        String[] stringArray = allowed;
        int n = allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String allow = stringArray[n2];
            if (this.current.equals(allow)) {
                return;
            }
            ++n2;
        }
        throw new InvalidStateException(this.current, allowed);
    }

    public Transition transition(String to) {
        return new TransitionImpl(to, false, new Class[0]);
    }

    public Transition transition(String to, boolean silent, Class<? extends Exception>[] ignore) {
        return new TransitionImpl(to, silent, ignore);
    }

    public Guard guard(String ... allowed) {
        return new GuardImpl(allowed);
    }

    public static class Builder {
        private static final Logger defaultLogger = Loggers.getLogger(StateGuard.class);
        private Logger logger;
        private ReadWriteLock lock;
        private String initial;
        private String failure;

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder lock(ReadWriteLock lock) {
            this.lock = lock;
            return this;
        }

        public Builder initial(String state) {
            this.initial = state;
            return this;
        }

        public Builder failure(String state) {
            this.failure = state;
            return this;
        }

        public StateGuard create() {
            return new StateGuard(this.logger != null ? this.logger : defaultLogger, this.lock != null ? this.lock : new ReentrantReadWriteLock(), this.initial, this.failure);
        }
    }

    private class GuardImpl
    implements Guard {
        private final String[] allowed;

        private GuardImpl(String[] allowed) {
            Preconditions.checkNotNull((Object)allowed);
            Preconditions.checkArgument((allowed.length != 0 ? 1 : 0) != 0);
            this.allowed = allowed;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "allowed=" + Arrays.toString(this.allowed) + '}';
        }

        @Override
        @Nullable
        public <V> V run(Action<V> action) throws Exception {
            Preconditions.checkNotNull(action);
            Lock lock = Locks.read((ReadWriteLock)StateGuard.this.readWriteLock);
            try {
                StateGuard.this._ensure(this.allowed);
                V v = action.run();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private class TransitionImpl
    implements Transition {
        private final String to;
        private final boolean silent;
        private final Class<? extends Exception>[] ignore;
        @Nullable
        private String[] allowed;

        private TransitionImpl(String to, boolean silent, Class<? extends Exception>[] ignore) {
            this.to = (String)Preconditions.checkNotNull((Object)to);
            this.silent = silent;
            this.ignore = (Class[])Preconditions.checkNotNull(ignore);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "to='" + this.to + '\'' + ", allowed=" + Arrays.toString(this.allowed) + '}';
        }

        @Override
        public TransitionImpl from(String ... allowed) {
            Preconditions.checkNotNull((Object)allowed);
            Preconditions.checkArgument((allowed.length != 0 ? 1 : 0) != 0);
            this.allowed = allowed;
            return this;
        }

        @Override
        @Nullable
        public <V> V run(Action<V> action) throws Exception {
            Lock lock = Locks.write((ReadWriteLock)StateGuard.this.readWriteLock);
            try {
                V v;
                if (this.allowed != null) {
                    StateGuard.this._ensure(this.allowed);
                }
                try {
                    StateGuard.this.log.debug("Transitioning: {} -> {}", (Object)StateGuard.this.current, (Object)this.to);
                    V result = action.run();
                    StateGuard.this.current = this.to;
                    StateGuard.this.log.debug("Transitioned: {}", (Object)this.to);
                    v = result;
                }
                catch (Throwable t) {
                    if (this.ignore(t)) {
                        StateGuard.this.current = this.to;
                        StateGuard.this.log.debug("Transitioned: {} ignoring: {}", (Object)this.to, (Object)t.toString());
                    } else {
                        if (this.silent) {
                            StateGuard.this.log.debug("Failed transition: {} -> {}", new Object[]{StateGuard.this.current, this.to, t});
                        } else {
                            StateGuard.this.log.error("Failed transition: {} -> {}", new Object[]{StateGuard.this.current, this.to, t});
                        }
                        if (StateGuard.this.failure != null) {
                            StateGuard.this.current = StateGuard.this.failure;
                        }
                    }
                    Throwables.propagateIfPossible((Throwable)t, Exception.class, Error.class);
                    throw new RuntimeException(t);
                }
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        private boolean ignore(Throwable t) {
            Class<? extends Exception>[] classArray = this.ignore;
            int n = this.ignore.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Exception> type = classArray[n2];
                if (type.isInstance(t)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

