/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.template;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.sonatype.nexus.common.template.TemplateAccessible;

@TemplateAccessible
public class TemplateThrowableAdapter {
    private final Throwable cause;

    public TemplateThrowableAdapter(Throwable cause) {
        this.cause = (Throwable)Preconditions.checkNotNull((Object)cause);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getType() {
        return this.cause.getClass().getName();
    }

    public String getSimpleType() {
        return this.cause.getClass().getSimpleName();
    }

    public String getMessage() {
        return this.cause.getMessage();
    }

    public String getTrace() {
        return Throwables.getStackTraceAsString((Throwable)this.cause);
    }

    public String toString() {
        return this.cause.toString();
    }
}

