/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.thread;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.sonatype.nexus.common.thread.TcclBlock;

public class TcclWrapper {
    private TcclWrapper() {
    }

    public static <T> T create(Class<T> type, T target, ClassLoader classLoader) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull((Object)classLoader);
        InvocationHandler handler = (proxy, method, args) -> {
            Throwable throwable = null;
            Object var6_7 = null;
            try (TcclBlock tccl = TcclBlock.begin(classLoader);){
                return method.invoke(target, args);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        };
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
    }
}

