/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.crypto.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.crypto.internal.PasswordCipher;
import org.sonatype.nexus.crypto.maven.MavenCipher;

@Named
@Singleton
public class MavenCipherImpl
implements MavenCipher {
    private static final char SHIELD_BEGIN = '{';
    private static final char SHIELD_END = '}';
    private static final int MIN_PAYLOAD_LENGTH = 32;
    private static final Pattern BASE_64_REGEX = Pattern.compile("[A-Za-z0-9+/]*={0,2}");
    private final PasswordCipher passwordCipher;

    @Inject
    public MavenCipherImpl(CryptoHelper cryptoHelper) {
        this.passwordCipher = new PasswordCipher(cryptoHelper);
    }

    @Override
    public String encrypt(String str, String passPhrase) {
        Preconditions.checkNotNull((Object)str);
        Preconditions.checkNotNull((Object)passPhrase);
        return String.valueOf('{') + this.doEncrypt(str, passPhrase) + '}';
    }

    private String doEncrypt(String str, String passPhrase) {
        return new String(this.passwordCipher.encrypt(str.getBytes(StandardCharsets.UTF_8), passPhrase), StandardCharsets.UTF_8);
    }

    @Override
    public String decrypt(String str, String passPhrase) {
        Preconditions.checkNotNull((Object)str);
        Preconditions.checkNotNull((Object)passPhrase);
        String payload = this.peel(str);
        Preconditions.checkArgument((payload != null ? 1 : 0) != 0, (Object)"Input string is not a password cipher");
        return this.doDecrypt(payload, passPhrase);
    }

    private String doDecrypt(String str, String passPhrase) {
        return new String(this.passwordCipher.decrypt(str.getBytes(StandardCharsets.UTF_8), passPhrase), StandardCharsets.UTF_8);
    }

    @Override
    public boolean isPasswordCipher(String str) {
        return this.peel(str) != null;
    }

    @Nullable
    private String peel(String str) {
        int payloadLength;
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        int start = str.indexOf(123) + 1;
        int stop = str.lastIndexOf(125);
        if (start > 0 && (payloadLength = stop - start) >= 32 && payloadLength % 4 == 0 && BASE_64_REGEX.matcher(str).region(start, stop).matches()) {
            return str.substring(start, stop);
        }
        return null;
    }
}

