/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.crypto.internal;

import com.google.common.base.Preconditions;
import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.crypto.RandomBytesGenerator;

@Named
public class RandomBytesGeneratorImpl
extends ComponentSupport
implements RandomBytesGenerator {
    private final SecureRandom random;

    @Inject
    public RandomBytesGeneratorImpl(CryptoHelper crypto) {
        this.random = ((CryptoHelper)Preconditions.checkNotNull((Object)crypto)).createSecureRandom();
    }

    @Override
    public byte[] generate(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        byte[] bytes = new byte[size];
        this.random.nextBytes(bytes);
        return bytes;
    }
}

