/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.expiry.Expirations;
import org.ehcache.expiry.Expiry;
import org.ehcache.spi.service.ServiceConfiguration;

public class BaseCacheConfiguration<K, V>
implements CacheConfiguration<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final Collection<ServiceConfiguration<?>> serviceConfigurations;
    private final ClassLoader classLoader;
    private final Expiry<? super K, ? super V> expiry;
    private final ResourcePools resourcePools;

    public BaseCacheConfiguration(Class<K> keyType, Class<V> valueType, EvictionAdvisor<? super K, ? super V> evictionAdvisor, ClassLoader classLoader, Expiry<? super K, ? super V> expiry, ResourcePools resourcePools, ServiceConfiguration<?> ... serviceConfigurations) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.evictionAdvisor = evictionAdvisor;
        this.classLoader = classLoader;
        this.expiry = expiry != null ? expiry : Expirations.noExpiration();
        this.resourcePools = resourcePools;
        this.serviceConfigurations = Collections.unmodifiableCollection(Arrays.asList(serviceConfigurations));
    }

    @Override
    public Collection<ServiceConfiguration<?>> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public EvictionAdvisor<? super K, ? super V> getEvictionAdvisor() {
        return this.evictionAdvisor;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Expiry<? super K, ? super V> getExpiry() {
        return this.expiry;
    }

    @Override
    public ResourcePools getResourcePools() {
        return this.resourcePools;
    }
}

