/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.internal.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ehcache.config.Builder;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.core.spi.service.ServiceFactory;
import org.ehcache.spi.service.PluralService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLocator
implements ServiceProvider<Service> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLocator.class);
    private final ServiceMap services;
    private final ReadWriteLock runningLock = new ReentrantReadWriteLock();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public static DependencySet dependencySet() {
        return new DependencySet();
    }

    private ServiceLocator(ServiceMap services) {
        this.services = services;
    }

    @Override
    public <T extends Service> T getService(Class<T> serviceType) {
        if (serviceType.isAnnotationPresent(PluralService.class)) {
            throw new IllegalArgumentException(serviceType.getName() + " is marked as a PluralService");
        }
        Collection<T> registeredServices = this.getServicesOfType(serviceType);
        if (registeredServices.size() > 1) {
            throw new AssertionError((Object)("The non-PluralService type" + serviceType.getName() + " has more than one service registered"));
        }
        return (T)(registeredServices.isEmpty() ? null : (Service)registeredServices.iterator().next());
    }

    @Override
    public <T extends Service> Collection<T> getServicesOfType(Class<T> serviceType) {
        return this.services.get(serviceType);
    }

    public boolean knowsServiceFor(ServiceConfiguration<?> serviceConfig) {
        return this.services.contains(serviceConfig.getServiceType());
    }

    public void startAllServices() throws Exception {
        LinkedList<Service> started = new LinkedList<Service>();
        Lock lock = this.runningLock.writeLock();
        lock.lock();
        try {
            if (!this.running.compareAndSet(false, true)) {
                throw new IllegalStateException("Already started!");
            }
            LinkedList<Service> unstarted = new LinkedList<Service>(this.services.all());
            int totalServices = unstarted.size();
            long start = System.currentTimeMillis();
            LOGGER.debug("Starting {} Services...", (Object)totalServices);
            while (!unstarted.isEmpty()) {
                boolean startedSomething = false;
                Iterator it = unstarted.iterator();
                while (it.hasNext()) {
                    Service s = (Service)it.next();
                    if (this.hasUnstartedDependencies(s, unstarted)) {
                        LOGGER.trace("Delaying starting {}", (Object)s);
                        continue;
                    }
                    LOGGER.trace("Starting {}", (Object)s);
                    s.start(this);
                    started.push(s);
                    it.remove();
                    startedSomething = true;
                }
                if (startedSomething) {
                    LOGGER.trace("Cycle complete: " + unstarted.size() + " Services remaining");
                    continue;
                }
                throw new IllegalStateException("Cyclic dependency in Service set: " + unstarted);
            }
            LOGGER.debug("All Services successfully started, {} Services in {}ms", (Object)totalServices, (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            while (!started.isEmpty()) {
                Service toBeStopped = (Service)started.pop();
                try {
                    toBeStopped.stop();
                }
                catch (Exception e1) {
                    LOGGER.error("Stopping Service failed due to ", (Throwable)e1);
                }
            }
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllServices() throws Exception {
        Exception firstException = null;
        Lock lock = this.runningLock.writeLock();
        lock.lock();
        try {
            if (!this.running.compareAndSet(true, false)) {
                throw new IllegalStateException("Already stopped!");
            }
            LinkedList<Service> running = new LinkedList<Service>(this.services.all());
            int totalServices = running.size();
            long start = System.currentTimeMillis();
            LOGGER.debug("Stopping {} Services...", (Object)totalServices);
            while (!running.isEmpty()) {
                boolean stoppedSomething = false;
                Iterator it = running.iterator();
                while (it.hasNext()) {
                    Service s = (Service)it.next();
                    if (this.hasRunningDependencies(s, running)) {
                        LOGGER.trace("Delaying stopping {}", (Object)s);
                        continue;
                    }
                    LOGGER.trace("Stopping {}", (Object)s);
                    try {
                        s.stop();
                    }
                    catch (Exception e) {
                        if (firstException == null) {
                            firstException = e;
                        }
                        LOGGER.error("Stopping Service failed due to ", (Throwable)e);
                    }
                    it.remove();
                    stoppedSomething = true;
                }
                if (stoppedSomething) {
                    LOGGER.trace("Cycle complete: " + running.size() + " Services remaining");
                    continue;
                }
                throw new AssertionError((Object)("Cyclic dependency in Service set: " + running));
            }
            LOGGER.debug("All Services successfully stopped, {} Services in {}ms", (Object)totalServices, (Object)(System.currentTimeMillis() - start));
        }
        finally {
            lock.unlock();
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    private boolean hasUnstartedDependencies(Service service, Iterable<Service> unstarted) {
        for (Class<? extends Service> dep : ServiceLocator.identifyTransitiveDependenciesOf(service.getClass())) {
            for (Service s : unstarted) {
                if (!dep.isInstance(s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRunningDependencies(Service service, Iterable<Service> running) {
        for (Class<? extends Service> dep : ServiceLocator.identifyTransitiveDependenciesOf(service.getClass())) {
            for (Service s : running) {
                if (!dep.isInstance(s)) continue;
                return true;
            }
        }
        return false;
    }

    private static Collection<Class<?>> getAllInterfaces(Class<?> clazz) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Class<?> i : c.getInterfaces()) {
                interfaces.add(i);
                interfaces.addAll(ServiceLocator.getAllInterfaces(i));
            }
        }
        return interfaces;
    }

    private static Set<Class<? extends Service>> identifyImmediateDependenciesOf(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends Service>> dependencies = new HashSet<Class<? extends Service>>();
        ServiceDependencies annotation = clazz.getAnnotation(ServiceDependencies.class);
        if (annotation != null) {
            for (Class<Service> clazz2 : annotation.value()) {
                if (!Service.class.isAssignableFrom(clazz2)) {
                    throw new IllegalStateException("Service dependency declared by " + clazz.getName() + " is not a Service: " + clazz2.getName());
                }
                Class<Service> serviceDependency = clazz2;
                dependencies.add(serviceDependency);
            }
        }
        for (Class<Service> clazz3 : clazz.getInterfaces()) {
            if (!Service.class.isAssignableFrom(clazz3)) continue;
            dependencies.addAll(ServiceLocator.identifyImmediateDependenciesOf((Class)Service.class.getClass().cast(clazz3)));
        }
        dependencies.addAll(ServiceLocator.identifyImmediateDependenciesOf(clazz.getSuperclass()));
        return dependencies;
    }

    private static Set<Class<? extends Service>> identifyTransitiveDependenciesOf(Class<?> clazz) {
        HashSet<Class<? extends Service>> transitive = new HashSet<Class<? extends Service>>();
        Set<Class<? extends Service>> dependencies = ServiceLocator.identifyImmediateDependenciesOf(clazz);
        transitive.addAll(dependencies);
        for (Class<? extends Service> klazz : dependencies) {
            transitive.addAll(ServiceLocator.identifyTransitiveDependenciesOf(klazz));
        }
        return transitive;
    }

    private static <T extends Service> Iterable<ServiceFactory<T>> getServiceFactories(ServiceLoader<ServiceFactory> serviceFactory) {
        ArrayList<ServiceFactory<T>> list = new ArrayList<ServiceFactory<T>>();
        for (ServiceFactory factory : serviceFactory) {
            list.add(factory);
        }
        return list;
    }

    public static <T> Collection<T> findAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceLocator.findAmongst(clazz, instances.toArray());
    }

    public static <T> Collection<T> findAmongst(Class<T> clazz, Object ... instances) {
        ArrayList<T> matches = new ArrayList<T>();
        for (Object instance : instances) {
            if (instance == null || !clazz.isAssignableFrom(instance.getClass())) continue;
            matches.add(clazz.cast(instance));
        }
        return Collections.unmodifiableCollection(matches);
    }

    public static <T> T findSingletonAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceLocator.findSingletonAmongst(clazz, instances.toArray());
    }

    public static <T> T findSingletonAmongst(Class<T> clazz, Object ... instances) {
        Collection<T> matches = ServiceLocator.findAmongst(clazz, instances);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return matches.iterator().next();
        }
        throw new IllegalArgumentException("More than one " + clazz.getName() + " found");
    }

    private static class ServiceMap {
        private final Map<Class<? extends Service>, Set<Service>> services = new HashMap<Class<? extends Service>, Set<Service>>();

        public ServiceMap(ServiceMap resolved) {
            for (Map.Entry<Class<? extends Service>, Set<Service>> e : resolved.services.entrySet()) {
                Set copy = Collections.newSetFromMap(new IdentityHashMap());
                copy.addAll((Collection)e.getValue());
                this.services.put(e.getKey(), copy);
            }
        }

        public ServiceMap() {
        }

        public <T extends Service> Set<T> get(Class<T> serviceType) {
            Set<Service> s = this.services.get(serviceType);
            if (s == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(s);
        }

        public ServiceMap addAll(Iterable<? extends Service> services) {
            for (Service service : services) {
                this.add(service);
            }
            return this;
        }

        public ServiceMap add(Service service) {
            HashSet<Class> serviceClazzes = new HashSet<Class>();
            serviceClazzes.add(service.getClass());
            for (Class i : ServiceLocator.getAllInterfaces(service.getClass())) {
                if (Service.class == i || !Service.class.isAssignableFrom(i)) continue;
                Class serviceClass = i;
                serviceClazzes.add(serviceClass);
            }
            for (Class serviceClazz : serviceClazzes) {
                Set<Service> registeredServices;
                if (serviceClazz.isAnnotationPresent(PluralService.class)) {
                    registeredServices = this.services.get(serviceClazz);
                    if (registeredServices == null) {
                        registeredServices = new LinkedHashSet<Service>();
                        this.services.put(serviceClazz, registeredServices);
                    }
                    registeredServices.add(service);
                    continue;
                }
                registeredServices = this.services.get(serviceClazz);
                if (registeredServices == null || registeredServices.isEmpty()) {
                    this.services.put(serviceClazz, Collections.singleton(service));
                    continue;
                }
                if (registeredServices.contains(service)) continue;
                StringBuilder message = new StringBuilder("Duplicate service implementation(s) found for ").append(service.getClass());
                for (Class serviceClass : serviceClazzes) {
                    Set<Service> s;
                    Service declaredService;
                    if (serviceClass.isAnnotationPresent(PluralService.class) || (declaredService = (s = this.services.get(serviceClass)) == null ? null : s.iterator().next()) == null) continue;
                    message.append("\n\t\t- ").append(serviceClass).append(" already has ").append(declaredService.getClass());
                }
                throw new IllegalStateException(message.toString());
            }
            return this;
        }

        public Set<Service> all() {
            Set all = Collections.newSetFromMap(new IdentityHashMap());
            for (Set<Service> s : this.services.values()) {
                all.addAll(s);
            }
            return Collections.unmodifiableSet(all);
        }

        public boolean contains(Class<? extends Service> request) {
            return this.services.containsKey(request);
        }
    }

    private static class DependencyException
    extends Exception {
        public DependencyException(String s) {
            super(s);
        }
    }

    public static class DependencySet
    implements Builder<ServiceLocator> {
        private final ServiceLoader<ServiceFactory> serviceLoader = ClassLoading.libraryServiceLoaderFor(ServiceFactory.class);
        private final ServiceMap provided = new ServiceMap();
        private final Set<Class<? extends Service>> requested = new HashSet<Class<? extends Service>>();

        public DependencySet with(Service service) {
            this.provided.add(service);
            return this;
        }

        public DependencySet with(Iterable<? extends Service> services) {
            for (Service service : services) {
                this.with(service);
            }
            return this;
        }

        public <T extends Service> DependencySet with(ServiceCreationConfiguration<T> config) {
            Class<T> serviceType = config.getServiceType();
            if (this.provided.contains(serviceType) && !serviceType.isAnnotationPresent(PluralService.class)) {
                return this;
            }
            Iterable serviceFactories = ServiceLocator.getServiceFactories(this.serviceLoader);
            boolean success = false;
            for (ServiceFactory factory : serviceFactories) {
                Class factoryServiceType = factory.getServiceType();
                if (!serviceType.isAssignableFrom(factoryServiceType)) continue;
                ServiceFactory serviceFactory = factory;
                this.with((Service)serviceFactory.create(config));
                success = true;
            }
            if (success) {
                return this;
            }
            throw new IllegalStateException("No factories exist for " + serviceType);
        }

        public DependencySet with(Class<? extends Service> clazz) {
            this.requested.add(clazz);
            return this;
        }

        public boolean contains(Class<? extends Service> serviceClass) {
            return this.provided.contains(serviceClass);
        }

        public <T extends Service> T providerOf(Class<T> serviceClass) {
            if (serviceClass.isAnnotationPresent(PluralService.class)) {
                throw new IllegalArgumentException("Cannot retrieve single provider for plural service");
            }
            Collection<T> providers = this.providersOf(serviceClass);
            switch (providers.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (T)((Service)providers.iterator().next());
                }
            }
            throw new AssertionError();
        }

        public <T extends Service> Collection<T> providersOf(Class<T> serviceClass) {
            return this.provided.get(serviceClass);
        }

        @Override
        public ServiceLocator build() {
            try {
                ServiceMap resolvedServices = new ServiceMap();
                for (Service service : this.provided.all()) {
                    resolvedServices = this.lookupDependenciesOf(resolvedServices, service.getClass()).add(service);
                }
                for (Class clazz : this.requested) {
                    if (clazz.isAnnotationPresent(PluralService.class)) {
                        try {
                            resolvedServices = this.lookupService(resolvedServices, clazz);
                            continue;
                        }
                        catch (DependencyException e) {
                            if (resolvedServices.contains(clazz)) continue;
                            throw e;
                        }
                    }
                    if (resolvedServices.contains(clazz)) continue;
                    resolvedServices = this.lookupService(resolvedServices, clazz);
                }
                return new ServiceLocator(resolvedServices);
            }
            catch (DependencyException e) {
                throw new IllegalStateException(e);
            }
        }

        ServiceMap lookupDependenciesOf(ServiceMap resolved, Class<? extends Service> requested) throws DependencyException {
            for (Class dependency : ServiceLocator.identifyImmediateDependenciesOf(requested)) {
                resolved = this.lookupService(resolved, dependency);
            }
            return resolved;
        }

        private <T extends Service> ServiceMap lookupService(ServiceMap resolved, Class<T> requested) throws DependencyException {
            if (resolved.contains(requested) && !requested.isAnnotationPresent(PluralService.class)) {
                return resolved;
            }
            if ((resolved = new ServiceMap(resolved).addAll(this.provided.get(requested))).contains(requested) && !requested.isAnnotationPresent(PluralService.class)) {
                return resolved;
            }
            Collection<ServiceFactory<T>> serviceFactories = this.discoverServices(resolved, requested);
            if (serviceFactories.size() > 1 && !requested.isAnnotationPresent(PluralService.class)) {
                throw new DependencyException("Multiple factories for non-plural service");
            }
            for (ServiceFactory factory : serviceFactories) {
                if (resolved.contains(factory.getServiceType())) continue;
                try {
                    resolved = this.lookupDependenciesOf(resolved, factory.getServiceType());
                }
                catch (DependencyException e) {
                    continue;
                }
                T service = factory.create(null);
                resolved = new ServiceMap(resolved).add((Service)service);
            }
            if (resolved.contains(requested)) {
                return resolved;
            }
            throw new DependencyException("Failed to find provider with satisfied dependency set for " + requested + " [candidates " + serviceFactories + "]");
        }

        private <T> Collection<ServiceFactory<? extends T>> discoverServices(ServiceMap resolved, Class<T> serviceClass) {
            ArrayList<ServiceFactory<T>> serviceFactories = new ArrayList<ServiceFactory<T>>();
            for (ServiceFactory factory : ServiceLocator.getServiceFactories(this.serviceLoader)) {
                Class factoryServiceType = factory.getServiceType();
                if (!serviceClass.isAssignableFrom(factoryServiceType) || factory.getClass().isAnnotationPresent(ServiceFactory.RequiresConfiguration.class) || this.provided.contains(factoryServiceType) || resolved.contains(factoryServiceType)) continue;
                ServiceFactory serviceFactory = factory;
                serviceFactories.add(serviceFactory);
            }
            return serviceFactories;
        }
    }
}

