/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.event;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.Time;

class AffinityBarrier
extends Phaser {
    private static final Logger log = LoggerFactory.getLogger(AffinityBarrier.class);
    private static final ThreadLocal<AffinityBarrier> CURRENT_BARRIER = new ThreadLocal();
    private final Executor coordinator;
    private final Executor executor;
    private final Time timeout;
    private final AtomicInteger cycleCounter = new AtomicInteger(-1);

    public AffinityBarrier(Executor coordinator, Executor executor, Time timeout) {
        super(1);
        this.coordinator = (Executor)Preconditions.checkNotNull((Object)coordinator);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.timeout = timeout;
    }

    @Nullable
    public static AffinityBarrier current() {
        return CURRENT_BARRIER.get();
    }

    public void coordinate(Runnable command) {
        this.coordinator.execute(() -> {
            this.await();
            CURRENT_BARRIER.set(this);
            try {
                command.run();
            }
            finally {
                CURRENT_BARRIER.remove();
            }
        });
    }

    public void execute(Runnable command) {
        this.register();
        this.executor.execute(() -> {
            try {
                command.run();
            }
            finally {
                this.arriveAndDeregister();
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public void await() {
        cycle = this.cycleCounter.getAndIncrement();
        while (cycle >= this.getPhase()) {
            try {
                if (cycle == this.getPhase()) {
                    this.arrive();
                }
                this.awaitAdvanceInterruptibly(cycle, this.timeout.value(), this.timeout.unit());
                continue;
            }
            catch (TimeoutException v0) {
                if (cycle != this.getPhase()) continue;
                this.register();
                overdueParties = 0;
                ** while (cycle == this.getPhase())
            }
lbl-1000:
            // 1 sources

            {
                ++overdueParties;
                this.arrive();
                continue;
            }
lbl20:
            // 1 sources

            if (overdueParties > 0) {
                AffinityBarrier.log.debug("Bumping affinity barrier: {} parties overdue", (Object)overdueParties);
            }
            this.arriveAndDeregister();
            continue;
            catch (IllegalStateException | InterruptedException e) {
                AffinityBarrier.log.warn("Bypassing affinity barrier: {}", (Object)e.toString());
                break;
            }
        }
    }

    @Override
    protected boolean onAdvance(int phase, int registeredParties) {
        return false;
    }
}

