/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.event;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.EagerSingleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;

@Named
@EagerSingleton
@ManagedObject
public class DebugEventInspector
extends ComponentSupport {
    private static final boolean ENABLED_DEFAULT = SystemPropertiesHelper.getBoolean((String)(String.valueOf(DebugEventInspector.class.getName()) + ".enabled"), (boolean)false);
    private volatile boolean enabled;
    private final EventManager eventManager;

    @Inject
    public DebugEventInspector(EventManager eventManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.setEnabled(ENABLED_DEFAULT);
    }

    @ManagedAttribute
    public boolean isEnabled() {
        return this.enabled;
    }

    @ManagedAttribute
    public void setEnabled(boolean enabled) {
        try {
            if (enabled && !this.enabled) {
                this.eventManager.register((Object)this);
            } else if (!enabled && this.enabled) {
                this.eventManager.unregister((Object)this);
            }
        }
        finally {
            this.enabled = enabled;
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void accept(Object event) {
        this.log.info("{}", event);
    }
}

