/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.event;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.inject.Key;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventBusFactory;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.event.WithAffinity;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.internal.event.EventExecutor;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.EVENTS)
@ManagedObject(typeClass=EventManager.class)
@Singleton
public class EventManagerImpl
extends LifecycleSupport
implements EventManager {
    static final int HOST_THREAD_POOL_SIZE = SystemPropertiesHelper.getInteger((String)(String.valueOf(EventManagerImpl.class.getName()) + ".poolSize"), (int)500);
    private final BeanLocator beanLocator;
    private final EventExecutor eventExecutor;
    private final EventBus eventBus;
    private final EventBus asyncBus;

    @Inject
    public EventManagerImpl(BeanLocator beanLocator, EventExecutor eventExecutor) {
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.eventExecutor = (EventExecutor)Preconditions.checkNotNull((Object)eventExecutor);
        this.eventBus = EventBusFactory.reentrantEventBus((String)"nexus");
        this.asyncBus = EventBusFactory.reentrantAsyncEventBus((String)"nexus.async", (Executor)eventExecutor);
    }

    protected void doStart() throws Exception {
        this.beanLocator.watch(Key.get(EventAware.class, Named.class), (Mediator)new EventAwareMediator(), (Object)this);
    }

    public void register(Object object) {
        boolean async = object instanceof EventAware.Asynchronous;
        if (async) {
            this.asyncBus.register(object);
        } else {
            this.eventBus.register(object);
        }
        this.log.trace("Registered {}{}", (Object)(async ? "ASYNC " : ""), object);
    }

    public void unregister(Object object) {
        boolean async = object instanceof EventAware.Asynchronous;
        if (async) {
            this.asyncBus.unregister(object);
        } else {
            this.eventBus.unregister(object);
        }
        this.log.trace("Unregistered {}{}", (Object)(async ? "ASYNC " : ""), object);
    }

    public void post(Object event) {
        this.eventBus.post(event);
        if (this.isAffinityEnabled() && event instanceof WithAffinity) {
            String affinity = ((WithAffinity)event).getAffinity();
            if (affinity != null) {
                this.eventExecutor.executeWithAffinity(affinity, () -> this.asyncBus.post(event));
            } else {
                this.log.warn("Event {} requested 'null' affinity", event);
                this.asyncBus.post(event);
            }
        } else {
            this.asyncBus.post(event);
        }
    }

    @ManagedAttribute
    @VisibleForTesting
    public boolean isCalmPeriod() {
        return this.eventExecutor.isCalmPeriod();
    }

    public boolean isAffinityEnabled() {
        return this.eventExecutor.isAffinityEnabled();
    }

    private static class EventAwareMediator
    implements Mediator<Named, EventAware, EventManagerImpl> {
        private EventAwareMediator() {
        }

        public void add(BeanEntry<Named, EventAware> entry, EventManagerImpl watcher) {
            watcher.register(entry.getValue());
        }

        public void remove(BeanEntry<Named, EventAware> entry, EventManagerImpl watcher) {
            watcher.unregister(entry.getValue());
        }
    }
}

