/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.log.LastShutdownTimeService;
import org.sonatype.nexus.common.log.LogManager;

@Named
@Singleton
public class LastShutdownTimeServiceImpl
extends ComponentSupport
implements LastShutdownTimeService {
    private static final String NEXUS_LOG_PATTERN = "(?<time>\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})";
    private static final String NEXUS_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String GROUP_NAME = "time";
    private static final String START_INDICATOR = "org.sonatype.nexus.pax.logging.NexusLogActivator - start";
    private static final String LOG_FILE_NAME = "nexus.log";
    private static final int DEFAULT_LINE_READING_LIMIT = 10000;
    private final DateFormat nexusFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Pattern nexusPattern = Pattern.compile("(?<time>\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})");
    private final LogManager logManager;
    private Optional<Date> shutdownTimeGuess = null;

    @Inject
    public LastShutdownTimeServiceImpl(LogManager logManager, @Named(value="${nexus.log.lastShutdownTime.enabled:-true}") boolean enabled) {
        this.logManager = logManager;
        if (!enabled) {
            this.shutdownTimeGuess = Optional.empty();
        }
    }

    public synchronized Optional<Date> estimateLastShutdownTime() {
        if (this.shutdownTimeGuess == null) {
            this.shutdownTimeGuess = this.findBestEstimate(this.logManager);
        }
        return this.shutdownTimeGuess;
    }

    private Optional<Date> findBestEstimate(LogManager logManager) {
        File nexusFile = logManager.getLogFile(LOG_FILE_NAME);
        Optional<Date> estimatedTime = Optional.empty();
        if (nexusFile == null) {
            this.log.warn("Missing {} , so last shutdown time can't be estimated.", (Object)LOG_FILE_NAME);
        } else if (nexusFile.length() == 0L) {
            this.log.warn("Empty log file {} , so last shutdown time can't be estimated.", (Object)nexusFile);
        } else {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ReversedLinesFileReader logReader = new ReversedLinesFileReader(nexusFile);){
                    estimatedTime = this.findShutdownTimeInLog(logReader, START_INDICATOR, this.nexusPattern, 10000, GROUP_NAME, this.nexusFormat);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to process file {}.  Assuming no previous start time", (Object)nexusFile, (Object)e);
            }
        }
        return estimatedTime;
    }

    @VisibleForTesting
    Optional<Date> findShutdownTimeInLog(ReversedLinesFileReader logReader, String startIndicator, Pattern timestampPattern, int lineScanLimit, String groupName, DateFormat dateFormat) throws IOException, ParseException {
        int linesRead = this.advanceReaderToShutdownLine(logReader, startIndicator, lineScanLimit);
        return this.findTimeFromPreviousInstance(logReader, timestampPattern, lineScanLimit - linesRead, groupName, dateFormat);
    }

    private int advanceReaderToShutdownLine(ReversedLinesFileReader logReader, String startIndicator, int lineScanLimit) throws IOException {
        String line;
        int lineCount = 0;
        while (lineCount++ < lineScanLimit && (line = logReader.readLine()) != null) {
            if (line.contains(startIndicator)) break;
        }
        return lineCount;
    }

    private Optional<Date> findTimeFromPreviousInstance(ReversedLinesFileReader logReader, Pattern timestampPattern, int lineScanLimit, String groupName, DateFormat dateFormat) throws IOException, ParseException {
        String line;
        int lineCount = 0;
        while (lineCount++ < lineScanLimit && (line = logReader.readLine()) != null) {
            Matcher matcher = timestampPattern.matcher(line);
            if (!matcher.find()) continue;
            return Optional.of(dateFormat.parse(matcher.group(groupName)));
        }
        return Optional.empty();
    }
}

