/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.servlet.InstrumentedFilter;
import com.codahale.metrics.servlets.PingServlet;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.internal.metrics.HealthCheckServlet;
import org.sonatype.nexus.internal.metrics.MetricsServlet;
import org.sonatype.nexus.internal.metrics.ThreadDumpServlet;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.SecurityFilter;
import org.sonatype.nexus.security.authz.PermissionsFilter;

public class MetricsModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(MetricsModule.class);
    private static final String MOUNT_POINT = "/service/metrics";

    protected void configure() {
        Clock clock = Clock.defaultClock();
        this.bind(Clock.class).toInstance((Object)clock);
        JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());
        this.bind(JsonFactory.class).toInstance((Object)jsonFactory);
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.bind(MetricsServlet.class);
                this.bind(HealthCheckServlet.class);
                this.serve("/service/metrics/ping", new String[0]).with((HttpServlet)new PingServlet());
                this.serve("/service/metrics/threads", new String[0]).with((HttpServlet)new ThreadDumpServlet());
                this.serve("/service/metrics/data", new String[0]).with(MetricsServlet.class);
                this.serve("/service/metrics/healthcheck", new String[0]).with(HealthCheckServlet.class);
                this.filter("/*", new String[0]).through((Filter)new InstrumentedFilter());
                this.bind(SecurityFilter.class);
                this.filter("/service/metrics/*", new String[0]).through(SecurityFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/service/metrics/**", new String[]{"nx-authc", "nx-anonymous", "nx-anticsrf-authc", PermissionsFilter.config((String[])new String[]{"nexus:metrics:read"})});
            }
        });
        log.info("Metrics support configured");
    }
}

