/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.metrics;

import com.codahale.metrics.JvmAttributeGaugeSet;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class MetricsServlet
extends com.codahale.metrics.servlets.MetricsServlet {
    @Inject
    public MetricsServlet(MetricRegistry registry) {
        super(registry);
        registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"vm"}), (Metric)new JvmAttributeGaugeSet());
        registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"memory"}), (Metric)new MemoryUsageGaugeSet());
        registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"buffers"}), (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"fd_usage"}), (Metric)new FileDescriptorRatioGauge());
        registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"thread-states"}), (Metric)new ThreadStatesGaugeSet());
        registry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"garbage-collectors"}), (Metric)new GarbageCollectorMetricSet());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean download = Boolean.parseBoolean(req.getParameter("download"));
        if (download) {
            resp.addHeader("Content-Disposition", "attachment; filename='metrics.json'");
        }
        super.doGet(req, resp);
    }
}

