/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.sonatype.nexus.ssl.spi.KeyStoreStorage;

public class FileKeyStoreStorage
implements KeyStoreStorage {
    private final File keyStoreFile;
    private long lastRead;

    public FileKeyStoreStorage(File keyStoreFile) {
        this.keyStoreFile = (File)Preconditions.checkNotNull((Object)keyStoreFile);
    }

    @VisibleForTesting
    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public boolean exists() {
        return this.keyStoreFile.exists();
    }

    public boolean modified() {
        return this.lastRead < this.keyStoreFile.lastModified();
    }

    public void load(KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, CertificateException, IOException {
        long readStart = System.currentTimeMillis();
        Throwable throwable = null;
        Object var6_6 = null;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.keyStoreFile));){
            keyStore.load(bis, password);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.lastRead = readStart;
    }

    public void save(KeyStore keyStore, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.keyStoreFile.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.keyStoreFile));){
            keyStore.store(bos, password);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.lastRead = System.currentTimeMillis();
    }

    public String toString() {
        return this.keyStoreFile.toURI().toString();
    }
}

