/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.internal.node.FileKeyStoreStorage;
import org.sonatype.nexus.ssl.spi.KeyStoreStorage;
import org.sonatype.nexus.ssl.spi.KeyStoreStorageManager;

@Named(value="node")
@Singleton
public class KeyStoreStorageManagerImpl
implements KeyStoreStorageManager {
    private final File basedir;

    @Inject
    public KeyStoreStorageManagerImpl(ApplicationDirectories directories) {
        this.basedir = new File(directories.getWorkDirectory("keystores"), "node");
    }

    @VisibleForTesting
    public KeyStoreStorageManagerImpl(File basedir) {
        this.basedir = (File)Preconditions.checkNotNull((Object)basedir);
    }

    public KeyStoreStorage createStorage(String keyStoreName) {
        Preconditions.checkNotNull((Object)keyStoreName);
        return new FileKeyStoreStorage(new File(this.basedir, keyStoreName));
    }
}

