/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.orient.DeploymentIdentifier;
import org.sonatype.nexus.internal.orient.DeploymentIdentifierEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class DeploymentAccessImpl
extends StateGuardLifecycleSupport
implements DeploymentAccess {
    private final Provider<DatabaseInstance> databaseInstance;
    private final DeploymentIdentifierEntityAdapter entityAdapter;
    private final NodeAccess nodeAccess;
    private String id;

    @Inject
    public DeploymentAccessImpl(@Named(value="config") Provider<DatabaseInstance> databaseInstance, NodeAccess nodeAccess) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = new DeploymentIdentifierEntityAdapter();
        this.nodeAccess = nodeAccess;
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx tx = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(tx);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.id = (String)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
            DeploymentIdentifier identifier = (DeploymentIdentifier)this.entityAdapter.get(db);
            if (identifier == null) {
                identifier = new DeploymentIdentifier();
                identifier.setId(this.nodeAccess.getId());
                this.entityAdapter.set(db, (Entity)identifier);
                this.log.info("Created new deployment identifier: {}", (Object)identifier);
            }
            return identifier.getId();
        });
    }

    @Guarded(by={"STARTED"})
    public String getId() {
        return this.id;
    }

    @Guarded(by={"STARTED"})
    public String getAlias() {
        return (String)OrientTransactional.inTx(this.databaseInstance).call(db -> {
            DeploymentIdentifier identifier = (DeploymentIdentifier)this.entityAdapter.get(db);
            return identifier.getAlias();
        });
    }

    @Guarded(by={"STARTED"})
    public void setAlias(String newAlias) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            DeploymentIdentifier identifier = (DeploymentIdentifier)this.entityAdapter.get(db);
            identifier.setAlias(newAlias);
            this.entityAdapter.set(db, (Entity)identifier);
        });
    }
}

