/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.OCompression;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategyFactory;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.Lifecycles;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabaseServer;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Priority(value=0x7FFFFFFF)
@Singleton
public class OrientBootstrap
extends StateGuardLifecycleSupport {
    private final NodeAccess nodeAccess;
    private final Provider<DatabaseServer> databaseServer;
    private final Provider<DatabaseManager> databaseManager;

    @Inject
    public OrientBootstrap(NodeAccess nodeAccess, Provider<DatabaseServer> databaseServer, Provider<DatabaseManager> databaseManager, Iterable<OCompression> managedCompressions, Iterable<OSQLFunctionAbstract> functions, Iterable<ORecordConflictStrategy> conflictStrategies) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.databaseServer = (Provider)Preconditions.checkNotNull(databaseServer);
        this.databaseManager = (Provider)Preconditions.checkNotNull(databaseManager);
        this.registerCompressions((Iterable)Preconditions.checkNotNull(managedCompressions));
        this.registerCustomFunctions((Iterable)Preconditions.checkNotNull(functions));
        this.registerConflictStrategies((Iterable)Preconditions.checkNotNull(conflictStrategies));
    }

    protected void doStart() throws Exception {
        this.nodeAccess.start();
        ((DatabaseServer)this.databaseServer.get()).start();
        Lifecycles.start((Object)this.databaseManager.get());
    }

    protected void doStop() throws Exception {
        Lifecycles.stop((Object)this.databaseManager.get());
        ((DatabaseServer)this.databaseServer.get()).stop();
        this.nodeAccess.stop();
    }

    private void registerCompressions(Iterable<OCompression> compressions) {
        for (OCompression compression : compressions) {
            try {
                this.log.debug("Registering OrientDB compression {} as '{}'", (Object)compression, (Object)compression.name());
                OCompressionFactory.INSTANCE.register(compression);
            }
            catch (IllegalArgumentException e) {
                this.log.debug("An OrientDB compression named '{}' was already registered", (Object)compression.name(), (Object)e);
            }
        }
    }

    private void registerCustomFunctions(Iterable<OSQLFunctionAbstract> functions) {
        this.log.debug("Registering custom OrientDB functions");
        for (OSQLFunctionAbstract function : functions) {
            this.log.debug("Registering OrientDB function " + function.getName());
            OSQLEngine.getInstance().registerFunction(function.getName(), (OSQLFunction)function);
        }
    }

    private void registerConflictStrategies(Iterable<ORecordConflictStrategy> strategies) {
        ORecordConflictStrategyFactory strategyFactory = Orient.instance().getRecordConflictStrategy();
        for (ORecordConflictStrategy strategy : strategies) {
            this.log.debug("Registering OrientDB conflict strategy {} as '{}'", (Object)strategy, (Object)strategy.getName());
            strategyFactory.registerImplementation((Object)strategy.getName(), (Object)strategy);
        }
    }
}

