/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Function;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.eclipse.sisu.EagerSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.commands.CommandSupport;
import org.sonatype.nexus.common.text.Strings2;

@Named
@EagerSingleton
public class OrientCommands
extends OConsoleDatabaseApp {
    private static final Logger log = LoggerFactory.getLogger(OrientCommands.class);
    private static final String SCOPE = "orient";
    private final SessionFactory sessionFactory;

    @Inject
    public OrientCommands(@Nullable SessionFactory sessionFactory) {
        super(new String[0]);
        this.sessionFactory = sessionFactory;
        for (Method method : this.getConsoleMethods().keySet()) {
            if (!method.isAnnotationPresent(ConsoleCommand.class)) continue;
            this.register(this.createOrientCommand(method));
        }
        this.onBefore();
    }

    private void register(Function command) {
        log.debug("Registering command: {}", (Object)command);
        if (this.sessionFactory != null) {
            this.sessionFactory.getRegistry().register((Object)command);
        } else {
            log.warn("Unable to register command, sessionFactory is null: {}", (Object)command);
        }
    }

    protected void printApplicationInfo() {
    }

    private Function createOrientCommand(final Method method) {
        return new CommandSupport(Action.class){
            private final String command;
            {
                super($anonymous0);
                this.command = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method2.getName()).replace('_', ' ');
            }

            public Object execute(Session session, List<Object> arguments) throws Exception {
                return OrientCommands.this.execute(method, this.command, arguments);
            }

            public String getScope() {
                return OrientCommands.SCOPE;
            }

            public String getName() {
                return method.getName();
            }

            public String getDescription() {
                return method.getAnnotation(ConsoleCommand.class).description();
            }

            public Completer getCompleter(boolean scoped) {
                return null;
            }

            public Action createNewAction(Session session) {
                return null;
            }

            protected void releaseAction(Action action) {
            }

            public String toString() {
                return method.toString();
            }
        };
    }

    public Object execute(Method method, String command, List<Object> params) {
        if (params.isEmpty() || !"--help".equals(params.get(0))) {
            ImmutableList expression = ImmutableList.builder().add((Object)command).addAll(params).build();
            this.execute(Joiner.on((char)' ').useForNull("null").join((Iterable)expression));
            return Strings2.NL;
        }
        this.syntaxError(command, method);
        return "";
    }

    public void error(String message, Object ... args) {
        if (!message.contains("Unrecognized command")) {
            super.error(message.replaceFirst("(?s)!Wrong syntax.*Expected", "Syntax"), args);
        }
    }
}

