/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.inject.AbstractModule;
import com.orientechnologies.orient.core.Orient;
import org.sonatype.nexus.internal.orient.DatabaseManagerImpl;
import org.sonatype.nexus.internal.orient.DatabaseServerImpl;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabaseServer;
import org.sonatype.nexus.orient.EncryptedRecordIdObfuscator;
import org.sonatype.nexus.orient.RecordIdObfuscator;

public class OrientModule
extends AbstractModule {
    protected void configure() {
        OrientModule.preloadOrientEngine();
        this.bind(DatabaseServer.class).to(DatabaseServerImpl.class);
        this.bind(DatabaseManager.class).to(DatabaseManagerImpl.class);
        this.bind(RecordIdObfuscator.class).to(EncryptedRecordIdObfuscator.class);
    }

    private static void preloadOrientEngine() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            Orient.instance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

