/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;
import org.sonatype.nexus.common.io.SanitizingJsonOutputStream;
import org.sonatype.nexus.orient.DatabaseExternalizer;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.supportzip.GeneratedContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;

class PasswordSanitizedJsonSource
extends GeneratedContentSourceSupport {
    private static final List<String> FIELDS = Arrays.asList("applicationPassword", "password", "systemPassword", "secret", "secretAccessKey", "sessionToken");
    private static final Set<String> EXCLUDED_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("api_key", "usertoken_record")));
    private static final String REPLACEMENT = "**REDACTED**";
    private final Provider<DatabaseInstance> databaseInstance;

    public PasswordSanitizedJsonSource(SupportBundle.ContentSource.Type type, String path, Provider<DatabaseInstance> databaseInstance) {
        super(type, path, SupportBundle.ContentSource.Priority.REQUIRED);
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
    }

    protected void generate(File file) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (SanitizingJsonOutputStream output = new SanitizingJsonOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), FIELDS, REPLACEMENT);){
            DatabaseExternalizer externalizer = ((DatabaseInstance)this.databaseInstance.get()).externalizer();
            externalizer.export((OutputStream)output, EXCLUDED_CLASSES);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

