/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.security.ClientInfo;
import org.sonatype.nexus.security.ClientInfoProvider;
import org.sonatype.nexus.security.authc.AuthenticationEvent;
import org.sonatype.nexus.security.authc.NexusAuthenticationEvent;

@Named
@Singleton
public class AuthenticationEventSubscriber
implements EventAware {
    private final Provider<EventManager> eventManager;
    private final Provider<ClientInfoProvider> clientInfoProvider;

    @Inject
    public AuthenticationEventSubscriber(Provider<EventManager> eventManager, Provider<ClientInfoProvider> clientInfoProvider) {
        this.eventManager = (Provider)Preconditions.checkNotNull(eventManager);
        this.clientInfoProvider = (Provider)Preconditions.checkNotNull(clientInfoProvider);
    }

    @Subscribe
    public void on(AuthenticationEvent event) {
        ClientInfo clientInfo = ((ClientInfoProvider)this.clientInfoProvider.get()).getCurrentThreadClientInfo();
        ((EventManager)this.eventManager.get()).post((Object)new NexusAuthenticationEvent(clientInfo == null ? new ClientInfo(event.getUserId(), null, null) : new ClientInfo(event.getUserId(), clientInfo.getRemoteIP(), clientInfo.getUserAgent()), event.isSuccessful()));
    }
}

