/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security;

import com.google.inject.AbstractModule;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import org.sonatype.nexus.internal.security.anonymous.AnonymousConfigurationStore;
import org.sonatype.nexus.internal.security.anonymous.OrientAnonymousConfigurationStore;
import org.sonatype.nexus.internal.security.realm.OrientRealmConfigurationStore;
import org.sonatype.nexus.security.FilterProviderSupport;
import org.sonatype.nexus.security.anonymous.AnonymousFilter;
import org.sonatype.nexus.security.authc.AntiCsrfFilter;
import org.sonatype.nexus.security.authc.NexusAuthenticationFilter;
import org.sonatype.nexus.security.authc.apikey.ApiKeyAuthenticationFilter;
import org.sonatype.nexus.security.authz.PermissionsFilter;
import org.sonatype.nexus.security.realm.RealmConfigurationStore;

@Named
public class SecurityModule
extends AbstractModule {
    protected void configure() {
        this.bind(FilterProviderSupport.filterKey((String)"nx-anonymous")).to(AnonymousFilter.class);
        this.bind(FilterProviderSupport.filterKey((String)"nx-authc")).to(NexusAuthenticationFilter.class);
        this.bind(FilterProviderSupport.filterKey((String)"nx-apikey-authc")).to(ApiKeyAuthenticationFilter.class);
        this.bind(FilterProviderSupport.filterKey((String)"nx-perms")).to(PermissionsFilter.class);
        this.bind(FilterProviderSupport.filterKey((String)"nx-anticsrf-authc")).to(AntiCsrfFilter.class);
        this.bind(FilterProviderSupport.filterKey((String)"authcBasic")).toProvider(AuthcBasicFilterProvider.class);
        this.bind(FilterProviderSupport.filterKey((String)"authcAntiCsrf")).toProvider(AuthcAntiCsrfFilterProvider.class);
        this.bind(FilterProviderSupport.filterKey((String)"authcApiKey")).toProvider(AuthcApiKeyFilterProvider.class);
        this.bind(AnonymousConfigurationStore.class).to(OrientAnonymousConfigurationStore.class);
        this.bind(RealmConfigurationStore.class).to(OrientRealmConfigurationStore.class);
    }

    @Singleton
    static class AuthcAntiCsrfFilterProvider
    extends FilterProviderSupport {
        @Inject
        AuthcAntiCsrfFilterProvider(AntiCsrfFilter filter) {
            super((Filter)filter);
        }
    }

    @Singleton
    static class AuthcApiKeyFilterProvider
    extends FilterProviderSupport {
        @Inject
        AuthcApiKeyFilterProvider(ApiKeyAuthenticationFilter filter) {
            super((Filter)filter);
        }
    }

    @Singleton
    static class AuthcBasicFilterProvider
    extends FilterProviderSupport {
        @Inject
        AuthcBasicFilterProvider(NexusAuthenticationFilter filter) {
            super((Filter)filter);
        }
    }
}

